/*===========================================================================

   FTW Beeper routine

   $ Version 3.0  23/10/92  21:58:36 $

   Copyright 1990, 1992 by Marco Savegnago.  All rights reserved.
   This software may be freely distributed and used, but it may not
   under any circumstances be sold by anyone other than the author.
   It may be distributed by a commercial company as long as it is
   for no cost.

===========================================================================*/


#include <dos.h>
#include <time.h>
#include "beep.hpp"


/*******************************************************************

	!!! Don't link it in this version !!!

*******************************************************************/

/*******************************************************************

	Beep with a given frequency and for a specified frequency

*******************************************************************/

void TPCBeep::beep(unsigned short frequency, unsigned short duration)
{

/*******************************************************************

	Turn sound on, wait for duration then turn it off.

*******************************************************************/

	soundOn(frequency);
	pause(duration);
	soundOff();
}


/*******************************************************************

	Pause for a give duration

*******************************************************************/

int TPCBeep::pause(unsigned duration)
{

/*******************************************************************

	Find what time it is to start with.

*******************************************************************/

	clock_t startClock = clock();

/*******************************************************************

	If 0 is passed in use default duration.

*******************************************************************/

	if (!duration)
		duration = defaultDuration;

/*******************************************************************

	If there is an error getting the time then exit immediately

*******************************************************************/

	if (startClock == -1)
		return (CLOCK_ERROR);

/*******************************************************************

	Find what time to wait for (taking into account wrap around).

*******************************************************************/

	clock_t waitFor = startClock + (((long)duration * CLK_TCK) / 1000L);
	clock_t wrappedFrom = MAX_CLOCK;
	if (waitFor < 0 || waitFor > MAX_CLOCK)
	{
		waitFor = MAX_CLOCK - startClock;
		wrappedFrom = startClock;
	}

	clock_t currentClock;
	do
	{
		currentClock = clock();
		if (currentClock == -1)
			return (CLOCK_ERROR);
	}while (currentClock <= waitFor || currentClock >= wrappedFrom);

	return (CLOCK_OKAY);
}


/*******************************************************************

	Turn ON the Beeper

*******************************************************************/

int TPCBeep::soundOn(unsigned short frequency)
{

/*******************************************************************

	If lower than 18Hz then forget it.

*******************************************************************/

	int result = TOO_LOW;

	if(!frequency)
		frequency = defaultFrq;

	if (frequency < 18)
		return (result);

/*******************************************************************

	Otherwise, get wavelength in DOS click units.

*******************************************************************/

	long waveLength = 1193181L / (long) frequency;

/*******************************************************************

	See if sound need to be turned on or if it already is.

*******************************************************************/

	unsigned char mask = inportb(0x61);
	result = CHANGED_PITCH;
	if (!(mask & 0x01) || !(mask & 0x02))
	{
		mask |= 0x03;
		outportb(0x61, mask);
		result = SOUND_ON;
	}

/*******************************************************************

	Send out the pitch.

*******************************************************************/

	outportb(0x43, 0xB6);
	outportb(0x42, LowByte(waveLength));
	outportb(0x42, HighByte(waveLength));
	return (result);
}


/*******************************************************************

	Turn OFF the Beeper

*******************************************************************/

void TPCBeep::soundOff()
{

/*******************************************************************

	Mask off the sound.

*******************************************************************/

	outportb(0x61, inportb(0x61 & ~0x03));
}
