/*===========================================================================

   FTW Beeper header

   $ Version 3.0  23/10/92  21:58:36 $

   Copyright 1990, 1992 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not        
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is          
   for no cost.                                                            
                                                                           
===========================================================================*/

#ifndef __BEEP_HPP
#define __BEEP_HPP

#define TOO_LOW -1
#define CHANGED_PITCH 1
#define SOUND_ON 0

#define LowByte(value) 0x000000FF & value
#define HighByte(value) 0x000000FF & (value >> 8)

#define MAX_CLOCK 2147483647L

#define CLOCK_ERROR -1
#define CLOCK_OKAY 0

_CLASSDEF(TPCBeep)
class TPCBeep
{
public:
        TPCBeep(unsigned short _defaultFrq = 180, unsigned short _defaultDuration = 100) :
                defaultFrq(_defaultFrq), defaultDuration(_defaultDuration) {}

        void beep(unsigned short frequency = 0, unsigned short duration = 0);
        int  pause(unsigned duration = 0);

protected:
        int soundOn(unsigned short frequency = 0);
        void soundOff();

private:
	unsigned short defaultFrq;
	unsigned short defaultDuration;
};

#endif  // !defined __BEEP_HPP
