/*===========================================================================

   FTW Background Bitmap display routine

   $ Version 3.0  23/10/92  21:58:36 $ 

   Copyright 1990, 1992 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not        
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is          
   for no cost.                                                            
                                                                           
===========================================================================*/

#include "bitmap.h"

/*******************************************************************

	Create a memory device context, specify a selected object,
	and set the DC's mapping mode.

*******************************************************************/

class CompatibleDC
{
    private:
	HDC hDCMem;
    public:
	CompatibleDC( HDC hDC )
	{
	    hDCMem = CreateCompatibleDC( hDC );
	    SetMapMode( hDCMem, GetMapMode( hDC ) );
	}
	~CompatibleDC( void ) { DeleteDC( hDCMem ); };
	HDC Get_hDCMem( void ) { return hDCMem; }
};

/*******************************************************************

	draw a bitmap

*******************************************************************/

void FAR Bitmap::Display( HDC hDC, short xStart, short yStart)
{
    POINT ptSize, ptOrigin;

    CompatibleDC MemoryDC( hDC );
    HDC hDCMem = MemoryDC.Get_hDCMem();
    SelectObject( hDCMem, hBitmap );

    ptSize = GetSize( hDC );
    ptOrigin.x = 0;
    ptOrigin.y = 0;
    DPtoLP( hDCMem, &ptOrigin, 1 );

    BitBlt( hDC, xStart, yStart, ptSize.x, ptSize.y,
	    hDCMem, ptOrigin.x, ptOrigin.y, SRCCOPY );
}

