/*===========================================================================

   FTW Background Bitmap display header

   $ Version 3.0  23/10/92  21:58:36 $ 

   Copyright 1990, 1992 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not        
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is          
   for no cost.                                                            
                                                                           
===========================================================================*/

#ifndef __BITMAP_H
#define __BITMAP_H

#include <windows.h>
#include <owl.h>

// Interface to simple library of classes to use for Windows GDI.

_CLASSDEF(Bitmap)
class Bitmap
{
    private:
        HANDLE hBitmap;
        int GetBitmap( BITMAP FAR * lpbm )
        {
            return GetObject( hBitmap, sizeof( BITMAP ), (LPSTR) lpbm );
        }
    public:
	Bitmap( HINSTANCE hInstance, char FAR * lpszBitmapName )
        {
            hBitmap = LoadBitmap( hInstance, lpszBitmapName );
        }
        ~Bitmap()
        {
            clear();
        }

	void clear()
	{
            DeleteObject( hBitmap );
	}

	void Display( HDC hDC, short xStart, short yStart );
        // Get the size of the bitmap in logical coordinates.

        POINT GetSize( HDC hDC )
        {
            BITMAP bm;
            POINT ptSize;

            GetBitmap( &bm );
            ptSize.x = bm.bmWidth;
            ptSize.y = bm.bmHeight;
            DPtoLP( hDC, &ptSize, 1 );
            return ptSize;
        }
};

#endif  // ! #defined __BITMAP_HPP
