/*===========================================================================

   FTW Device Communications routine

   $ Version 3.0  23/10/92  21:58:36 $ 

   Copyright 1990, 1992 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not        
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is          
   for no cost.                                                            
                                                                           
===========================================================================*/

#include "comm.h"
#include <string.h>
#include <strstrea.h>

/*******************************************************************

	Create a Comm Object

*******************************************************************/

TFtwCom::TFtwCom(int num, char *c1, char *c2)
{
    open=FALSE;
	setParam(num,c1,c2);
}

TFtwCom::~TFtwCom()
{
    if(open)
		closeCom();
}


void TFtwCom::setParam(int num, char *c1, char *c2)
{
	numOfRadio=num;
	strcpy(com[0],c1);
	strcpy(com[1],c2);
	numOfCom = 0 != strcmp(com[0], com[1]);
}

/*******************************************************************

	Open the port(s).

*******************************************************************/

TFtwCom::openCom()
{

/*******************************************************************

	For each defined port Open it using WINDOWS API COMM functions

*******************************************************************/

	for (int i=0; i<=numOfCom; i++)
	{
		if ((comResult[i]=OpenComm(com[i],1,16)) < 0)
							return 1;

        char dummy[20];
		ostrstream initCom(dummy, sizeof(dummy));
		initCom << com[i] << ":4800,n,8,2";
		BuildCommDCB(initCom.str(), &dcb[i]);

		if(SetCommState(&dcb[i]) < 0)
					return 2;
	}
	return 0;
}


/*******************************************************************

	Send the specified CAT command

*******************************************************************/


TFtwCom::comFunct(int side, int t)
{

	char cmdString[] = "\0\0\0\0\0";

/*******************************************************************

		      /*  CAT-ON CAT-OFF   RX      TX */

*******************************************************************/

	char cmdChar[] = { '\0', '\x80', '\x88', '\x08' };

	cmdString[4]=cmdChar[t];

	return (sendCom(side,cmdString,5));
}


/*******************************************************************

	Send a buffer to the give side

*******************************************************************/


TFtwCom::sendCom(int side, char *str, int len)
{
	int ret;

/*******************************************************************

	If there is more than 1 radio

*******************************************************************/

	if(numOfRadio)
	{

/*******************************************************************

	If the com is > 1 then write directly on it

*******************************************************************/

		if(numOfCom)
			WriteComm(dcb[side].Id,str,len);

/*******************************************************************

	else switch radio using DTR and RTS

*******************************************************************/

		else
		{
			EscapeCommFunction(dcb[0].Id,(side) ? CLRDTR : CLRRTS );
			EscapeCommFunction(dcb[0].Id,(side) ? SETRTS : SETDTR );
			ret=WriteComm(dcb[0].Id,str,len);
		}
	}

/*******************************************************************

	else write directly on first port

*******************************************************************/


	else
		ret=WriteComm(dcb[0].Id,str,len);

	return ret;
}


/*******************************************************************

	Close all open com

*******************************************************************/

TFtwCom::closeCom()
{

/*******************************************************************

	For each port opened close it.

	Return 1 if an error occur.

*******************************************************************/

	for (int i=0; i<=numOfCom; i++)
		if((comResult[i]=CloseComm(dcb[i].Id)) < 0)
											return 1;
	return 0;
}

