/*===========================================================================

   FTW configuration routine

   $ Version 3.1  10/09/93  22:16:36 $ 

   Copyright 1990, 1993 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not        
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is          
   for no cost.                                                            
                                                                           
===========================================================================*/

#include "config.h"
#include <ctype.h>
#include <string.h>


/*******************************************************************

	Get number of Radio

*******************************************************************/

int TConfigParam::numOfRadio()
{
	return numRadio;
}

/*******************************************************************

	Set number of Radio

*******************************************************************/

int TConfigParam::setNumOfRadio(int num)
{
	return numRadio=num;
}

/*******************************************************************

	Set COM port of Radio 1

*******************************************************************/

void TConfigParam::setRadio1Com(Pchar theCom)
{
	strcpy(radio1Com,theCom);
	strupr(radio1Com);
}


/*******************************************************************

	Get COM port of Radio 1

*******************************************************************/

Pchar TConfigParam::getRadio1Com()
{
	return radio1Com;
}

/*******************************************************************

	Set RADIO type Radio 1

*******************************************************************/

void TConfigParam::setRadio1Type(Pchar theType)
{
	strcpy(radio1Type,theType);
	strupr(radio1Type);
}


/*******************************************************************

	Get RADIO type Radio 1

*******************************************************************/

Pchar TConfigParam::getRadio1Type()
{
	return radio1Type;
}

/*******************************************************************

	Set COM port of Radio 2

*******************************************************************/

void TConfigParam::setRadio2Com(Pchar theCom)
{
	strcpy(radio2Com,theCom);
	strupr(radio2Com);
}

/*******************************************************************

	Get COM port of Radio 2

*******************************************************************/

Pchar TConfigParam::getRadio2Com()
{
	return radio2Com;
}

/*******************************************************************

	Set RADIO type Radio 2

*******************************************************************/

void TConfigParam::setRadio2Type(Pchar theType)
{
	strcpy(radio2Type,theType);
	strupr(radio2Type);
}

/*******************************************************************

	Get RADIO type Radio 2

*******************************************************************/

Pchar TConfigParam::getRadio2Type()
{
	return radio2Type;
}

/*******************************************************************

	Save & Restore configuration param ?

*******************************************************************/

int TConfigParam::isSaveFrq()
{
	return saveRestore;
}


/*******************************************************************

	Save & Restore configuration param !!

*******************************************************************/

int TConfigParam::setSaveFrq(int save)
{
	return saveRestore=save;
}

/*******************************************************************

	Save & Restore configuration param !!

*******************************************************************/

int TConfigParam::setSaveFrq(Pchar str)
{
	return saveRestore=getBoolValue(str);
}

/*******************************************************************

	Convert letter setting to numeric

*******************************************************************/

int TConfigParam::getBoolValue(Pchar BoolStr)
{
	switch (toupper(*BoolStr))
	{
		case 'Y':
		case 'S':
		case 'J':
		case '1':
			return 1;
		default:
			return 0;
	}
}

/*******************************************************************

	Convert numeric setting to letter

*******************************************************************/

Pchar  TConfigParam::setSaveFrqString(Pchar dest)
{
	if (saveRestore)
		strcpy(dest,"Yes");
	else
		strcpy(dest,"No");

	return dest;
}

/*******************************************************************

	Set/Get memory Filename

*******************************************************************/

void TConfigParam::setMemoryFilename(Pchar filename)
{
    strcpy(memoryFile, filename);
}

Pchar TConfigParam::getMemoryFilename()
{
	return memoryFile;
}
