/*===========================================================================

   FTW configuration header

   $ Version 3.1  10/09/93  22:18:37 $ 

   Copyright 1990, 1993 by Marco Savegnago.  All rights reserved.
   This software may be freely distributed and used, but it may not        
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is          
   for no cost.                                                            
                                                                           
===========================================================================*/


#ifndef __CONFIG_H
#define __CONFIG_H

#include "freq.h"
#include <dir.h>	// for MAXPATH


_CLASSDEF(TConfigParam)
class TConfigParam
{
	int  numRadio;     // 0 = 1 Radio, 1 = 2 Radio 
        
    Frequency 	frequency1;
	char 		radio1Com[5];
	char 		radio1Type[7];

	Frequency 	frequency2;
	char 		radio2Com[5];
	char 		radio2Type[7];

    int  		saveRestore;
    char 		memoryFile[MAXPATH];

public:

	inline int 		numOfRadio();
    inline int 		setNumOfRadio( int num );
	void 			setRadio1Com( Pchar theCom );
    inline Pchar 	getRadio1Com();
	void 			setRadio1Type( Pchar theType );
    inline Pchar 	getRadio1Type();
	void 			setRadio2Com( Pchar theCom );
    inline Pchar 	getRadio2Com();
	void 			setRadio2Type( Pchar theType );
    inline Pchar 	getRadio2Type();
    inline int 		isSaveFrq();
	int 			setSaveFrq( int save );
	int 			setSaveFrq( Pchar );
	int 			getBoolValue( Pchar str );
	Pchar 			setSaveFrqString( Pchar dest );
	void 			setMemoryFilename( Pchar filename );
	Pchar 			getMemoryFilename();
};

#endif // !defined __CONFIG_H