/*------------------------------------------------------------------------*/
/*                                                                        */
/*  CSTRNG.H                                                              */
/*                                                                        */
/*  A simple String Object (compatible with BI Container Class Library    */
/*                                                                        */
/*------------------------------------------------------------------------*/

#include "cstring.h"
#include <stdlib.h>

CString::CString( const char *aPtr )
{
    if ( aPtr == 0 )
        	aPtr = "";

    len = strlen( aPtr ) + 1;
    theString = new char[ len ];
    CHECK( theString != 0 );
    strcpy( theString, aPtr );
}

CString::CString( const CString& sourceString )
{
    len = sourceString.len;
    theString = new char[ len ];
    CHECK( theString != 0 );
    strcpy( theString, sourceString.theString );
}

CString::isEqual( const Object& testString ) const
{
    return ( len == ((CString&)testString).len &&
             !strcmp( theString, ((CString&)testString).theString ) );
}

int CString::isLessThan( const Object& testString ) const
{
    return ( strcmp ( theString, ((CString&)testString).theString ) < 0 );
}

hashValueType CString::hashValue() const
{
    hashValueType   value = hashValueType(0);
    for( int i = 0; i < len; i++ )
    {
        value ^= theString[i];
        value = _rotl( value, 1 );
    }

    return value;
}

void CString::printOn( ostream& outputStream ) const
{
    outputStream << theString;
}

CString& CString::operator =( const CString& sourceString )
{
    if ( *this != sourceString )
    {
        if ( len != sourceString.len )
        {
            delete theString;
            len = sourceString.len;
            theString = new char[ len ];
            CHECK( theString != 0 );
        }

        strcpy( theString, sourceString.theString );
    }

    return *this;
}

// +
CString operator+(const CString& s1, const char *s2)
{
    CString tmp(s1);
    tmp += s2;
    return tmp;
}

CString operator+(const char *s1, const CString& s2)
{
    CString tmp(s1);
    tmp += s2;
    return tmp;
}

CString operator+(const CString& s1, const CString& s2)
{
    CString tmp(s1);
    tmp += s2;
    return tmp;
}

// +=
CString& CString::operator+=(const char ch)
{
    char _FAR * tmpString;

    sizeType stringLen = len;

    tmpString = new char[stringLen + 2];

	CHECK( tmpString != 0 );

    strcpy(tmpString, theString);
    tmpString[stringLen] = ch;
    tmpString[stringLen+1] = '\0';

    delete theString;

    len = stringLen + 1;

    theString=tmpString;

    return *this;
}

CString& CString::operator+=(const char *s)
{
    char _FAR * tmpString = theString;

    sizeType stringLen = strlen(theString) + strlen(s);

    theString = new char[stringLen + 1];

    CHECK( theString != 0 );

    strcpy(theString, tmpString);
    strcat(theString, s);

    len=stringLen;

    if(tmpString)
        delete tmpString;

    return *this;
}

CString& CString::operator+=(const CString& s)
{

    char _FAR * tmpString;

	sizeType stringLen = strlen(theString) + strlen(s);

    tmpString = new char[stringLen + 1];

    CHECK( tmpString != 0 );

    strcpy(tmpString, theString);
    strcat(tmpString, s);

    len=stringLen;

    delete theString;

    theString=tmpString;

    return *this;
}

