/*------------------------------------------------------------------------*/
/*                                                                        */
/*  CSTRNG.H                                                              */
/*                                                                        */
/*  A simple String Object (compatible with BI Container Class Library    */
/*                                                                        */
/*------------------------------------------------------------------------*/

#ifndef __CSTRING_H
#define __CSTRING_H

#if !defined( __CLSTYPES_H )
#include <ClsTypes.h>
#endif  // __CLSTYPES_H

#if !defined( __SORTABLE_H )
#include <Sortable.h>
#endif  // __SORTABLE_H

#if !defined( __STRING_H )
#include <string.h>
#endif  // __STRING_H

#if !defined( __CHECKS_H )
#include <Checks.h>
#endif  // __CHECKS_H

class CString: public Sortable
{
public:

    CString( const char _FAR * = "" );
    CString( const CString _FAR & );

    virtual ~CString()
    {
        delete theString;
    }


    CString& operator = ( const CString _FAR & );
    operator char _FAR *() const;

    CString& CString::operator+=(const char ch);
    CString& CString::operator+=(const char* s);
    CString& CString::operator+=(const CString& s);

    virtual int isEqual( const Object _FAR & ) const;
    virtual int isLessThan( const Object _FAR & ) const;

    virtual classType isA() const
    {
        return stringClass;
    }

    virtual char _FAR *nameOf() const
    {
        return "CString";
    }

    virtual hashValueType hashValue() const;
    virtual void printOn( ostream _FAR & ) const;
    
    friend CString operator +  (const CString&, const CString&);
    friend CString operator +  (const CString&, const char*);
    friend CString operator +  (const char*,    const CString&);

protected:

    sizeType len;
    char _FAR *theString;

};

inline CString::operator char _FAR *() const
{
    return theString;
}

#endif // __CSTRING_H