/*===========================================================================

   FTW Frequency Object routine

   $ Version 3.1  10/09/93  22:21:12 $ 

   Copyright 1990, 1993 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is          
   for no cost.                                                            
                                                                           
===========================================================================*/

#include "freq.h"

#include <stdlib.h>
#include <ctype.h>
#include <string.h>

/*******************************************************************

	Frequency class used in FTW and RCW

*******************************************************************/

#undef RCW

static unsigned long stepVal[] = { 500L, 1000L, 1250L, 2000L, 2500L };

static unsigned _5_valid_frq[] =
	    { 0000,  500, 1000, 1500, 2000, 2500, 3000, 3500, 4000,
	      4500, 5000, 5500, 6000, 6500, 7000, 7500, 8000, 8500,
	      9000, 9500, 0000 };

static unsigned _10_valid_frq[] =
	    { 0000,  500, 1000, 1500, 2000, 2500, 3000, 3500, 4000,
	      4500, 5000, 5500, 6000, 6500, 7000, 7500, 8000, 8500,
	      9000, 9500, 0000 };

static unsigned _125_valid_frq[] =
	    { 0000, 1250, 2500, 3750, 5000, 6250, 7500, 8750, 0000 };

static unsigned _20_valid_frq[] =
	    { 0000, 2000, 4000, 6000, 8000, 0000 };

static unsigned _25_valid_frq[] =
	    { 0000, 1250, 2500, 3750, 5000, 6250, 7500, 8750, 0000 };

struct VALID_FRQ
{
    unsigned *lista;
    int  lung_lista;
};


/*******************************************************************

	VFO Frequency Matrix

*******************************************************************/

static VALID_FRQ validFrqArray[] =
{
    { _5_valid_frq , 20 }, { _10_valid_frq, 20 }, {_125_valid_frq, 8  },
    { _20_valid_frq, 5  }, { _25_valid_frq, 8  }
};

/*******************************************************************

	Create an Frequency Object at a given frequency, step, and
	type.

*******************************************************************/

Frequency::Frequency(unsigned long frequency, int step, char type, char ch)
{
	theType=type;
	theFrequency=frequency;
	theStep=step;
	checkMode=ch;
	frequencyString = new char [9];
}

/*******************************************************************

	Delete it..

*******************************************************************/

Frequency::~Frequency()
{
	delete frequencyString;
}

/*******************************************************************

	Set the frequency value

*******************************************************************/

void Frequency::setValue(unsigned long frequency)
{
	theFrequency=frequency;
	checkBound();
}

/*******************************************************************

	Set the type.

*******************************************************************/

void Frequency::setType(char type)
{
	theType=type;
}
/*******************************************************************

	Yes, checkmode.

*******************************************************************/

char Frequency::setCheck(char ch)
{
	return checkMode=ch;
}


/*******************************************************************

	Is checkmode?

*******************************************************************/

char Frequency::getCheck() const
{
	return checkMode;
}

/*******************************************************************

	What kind of frequency (Vhf/Uhf)

*******************************************************************/

char Frequency::getType() const 
{
	return theType;
}

/*******************************************************************

	Set the give frequency

*******************************************************************/

void Frequency::operator =(unsigned long frequency)
{
	theFrequency=frequency;
	checkBound();
}

/*******************************************************************

	Set the give frequency form string stripping the .

*******************************************************************/

void Frequency::operator =(char *frequency)
{
	char buff[10];
	int i=0,j=0;

	while(i<10 && frequency[j])
	{
		if (isdigit(frequency[j]))
		{
			buff[i++]=frequency[j++];
		}
		else
			j++;
	}

	// buff[--j]='\0';

    buff[i]='\0';

	if ((j = strlen(buff)) < 8)
	{
		for (i = 0 ; i < (8 - j) ; i++)
			*(buff+j+i) = '0';
		*(buff+j+i) = NULL;
	}

	unsigned long tempFrequency=atol(buff);

	if(tempFrequency!=0L)
		theFrequency=tempFrequency;

	checkBound();
}

/*******************************************************************

	Set the Step

*******************************************************************/

void Frequency::setStep(int step)
{
	theStep=step;
}

/*******************************************************************

	Get the frequency value

*******************************************************************/

unsigned long Frequency::value() const 
{
	return theFrequency;
}

/*******************************************************************

	Sync frequency and step (use internally by Frequency)

*******************************************************************/

void Frequency::syncValue()
{
	while(!checkBase())
		theFrequency -= 250L;
}

/*******************************************************************

	Set the bounds of frequency

*******************************************************************/

void Frequency::setBounds(unsigned long lower, unsigned long upper)
{
	lowerBound=lower;
    upperBound=upper;
}

/*******************************************************************

	Get the bounds of frequency

*******************************************************************/

void Frequency::getBounds(unsigned long& lower, unsigned long& upper)
{
	lower=lowerBound;
    upper=upperBound;
}


/*******************************************************************

	Check if the frequency setting is compatible with the given step

*******************************************************************/


int Frequency::checkBase()
{
	unsigned int frequencyDigit=(unsigned int)(theFrequency-((theFrequency/10000L)*10000L));

	for (int i=0; i<(validFrqArray[theStep].lung_lista); i++)
			if(frequencyDigit==validFrqArray[theStep].lista[i])
								       					return 1;
	return 0;
}

/*******************************************************************

	Go up for a give frequency

*******************************************************************/

unsigned long Frequency::operator += (unsigned long frq)
{
	theFrequency += frq;
	checkBound();

	return theFrequency;
}

/*******************************************************************

	Go down for a give frequency

*******************************************************************/

unsigned long Frequency::operator -= (unsigned long frq)
{
	theFrequency -= frq;
	checkBound();

	return theFrequency;
}

/*******************************************************************

	Go up for a give frequency

*******************************************************************/

unsigned long Frequency::operator += (RFrequency frq)
{
	theFrequency += frq.value();
	checkBound();

	return theFrequency;
}


/*******************************************************************

	Go down for a give frequency

*******************************************************************/

unsigned long Frequency::operator -= (RFrequency frq)
{
	theFrequency -= frq.value();
	checkBound();

	return theFrequency;
}


/*******************************************************************

	Get the frequency in string mode

*******************************************************************/

char * Frequency::string() const
{
	char buf[9];
	int i = 0, j;

	unsigned long tempFrequency=theFrequency;

	do
	{
		buf[i++] = (tempFrequency % 10) + '0';
		tempFrequency /= 10;
	}
	while ( i < 8 );

	for ( i = 0, j = 7 ; i < 8 ; i++ , j--)
	{

#ifdef RCW

		if ((j == 7) && (buf[j] == '0'))
					buf[j] = ' ';
#endif

		if (j == 4)
			frequencyString[i++] = '.';

		frequencyString[i] = buf[j];
	}

	frequencyString[8]='\0';
	return frequencyString;
}

/*******************************************************************

	Or via operator const char *, const

*******************************************************************/

Frequency::operator char *() const
{
	return string();
}

/*******************************************************************

	Go Up (step)

*******************************************************************/

unsigned long Frequency::up(int step)
{
	setStep(step);
	syncValue();
	theFrequency += stepVal[step];
	checkBound();

	return theFrequency;
}

/*******************************************************************

	Go Down (step)

*******************************************************************/

unsigned long Frequency::down(int step)
{
	setStep(step);
	syncValue();
	theFrequency -= stepVal[step];
	checkBound();

	return theFrequency;
}

/*******************************************************************

	Check bounds

*******************************************************************/

void Frequency::checkBound()
{
    if (!checkMode)
				return;


    if(theType != FTALL)
    {
		if ( theFrequency < lowerBound)
		{
			theFrequency = lowerBound;
			return;
		}	

		if (( theFrequency >= lowerBound) &&
					( theFrequency <= upperBound))
												return;

		if ( theFrequency > upperBound)
		{
			theFrequency = upperBound;
			return;
		}
    }

    return;


/*
    switch (theType)
    {
		case FT212:
			if ( theFrequency < 43000000L)
			{
				theFrequency = 43000000L;
				return;
			}	

			if (( theFrequency >= 43000000L) &&
					( theFrequency <= 44000000L))
												return;

			if ( theFrequency > 44000000L)
			{
				theFrequency = 44000000L;
				return;
			}
			break;

		case FT712:
			if ( theFrequency < 14400000L )
			{
				theFrequency = 14400000L;
				return;
			}

			if (( theFrequency >= 14400000L) &&
					( theFrequency <= 14800000L))
												return;

			if ( theFrequency > 14800000L)
			{
				theFrequency = 14800000L;
				return;
			}
			break;

		case FTALL:
			if ((( theFrequency >= 14400000L) &&
					( theFrequency <= 14800000L)) ||
				(( theFrequency >= 43000000L) &&
					( theFrequency <= 44000000L)))
												return;
			else
				theFrequency=14500000L;
			break;
    	}

	return;
	*/
}

