/*===========================================================================

   FTW Frequency Object header

   $ Version 3.1  10/09/93  22:21:12 $

   Copyright 1990, 1993 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is          
   for no cost.                                                            
                                                                           
===========================================================================*/

#ifndef __FREQ_H
#define __FREQ_H

#include <owldefs.h>

enum { FT212, FT712, FTALL };
enum { NOCHECKED, CHECKED };


_CLASSDEF(Frequency)
class Frequency
{
	char 			theType;
	Pchar 			frequencyString;
	unsigned long 	theFrequency;

    unsigned long 	lowerBound;
    unsigned long 	upperBound;

    int  			theStep;
	int 			checkBase();
	char 			checkMode;

public:
	inline Frequency(unsigned long frequency=0, int step=0, char type=0, char ch=1);
    inline ~Frequency();
	inline void setType(char type);
    inline char getType() const;
    inline void setValue(unsigned long frequency);
	inline void setStep(int step);
	unsigned long value() const;
	void syncValue();
    inline void setBounds(unsigned long lower, unsigned long upper);
    inline void getBounds(unsigned long& lower, unsigned long& upper);
	unsigned long operator += (unsigned long frq);
	unsigned long operator -= (unsigned long frq);
	unsigned long operator += (RFrequency frq);
	unsigned long operator -= (RFrequency frq);
	void operator = (unsigned long frq);
    void operator = (Pchar frequency);
	Pchar string() const;
	unsigned long up   (int step);
	unsigned long down (int step);
	void checkBound();
	inline char setCheck(char ch);
	inline char getCheck() const;
	inline operator Pchar() const;
};

#endif	// !defined __FREQ_H