/*===========================================================================

   FTW Frequency Indicatory 

   $ Version 3.1  31/05/93  21:58:36 $ 

   Copyright 1990, 1992 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not        
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is
   for no cost.
                                                                           
===========================================================================*/

#include "frqind.h"
#include "ftwid.h"

TFrqIndicator::TFrqIndicator(PTWindowsObject AParent, int ResourceId, WORD ATextLen, unsigned int clipFormat) :
		TStatic(AParent, ResourceId, ATextLen)
{
		ftwClipboard=clipFormat;
}

void TFrqIndicator::GetWindowClass(WNDCLASS& AWndClass)
{
	TStatic::GetWindowClass(AWndClass);
}

void TFrqIndicator::WMLButtonDown(RTMessage Msg)
{
	SendMessage(Parent->HWindow, CM_TOGGLESIDE, 0, 0);
}

void TFrqIndicator::WMRButtonDown(RTMessage Msg)
{
    SendMessage(Parent->HWindow, WM_ACTIVE_POPUP, Attr.Id, 1L);

	/*******************************************************************

    See if there is data on clipboard available

	*******************************************************************/

	BOOL isClipboard=FALSE;

	if (OpenClipboard(HWindow))
    {
		if (IsClipboardFormatAvailable(ftwClipboard))
         								isClipboard=TRUE;

        CloseClipboard();
    }
	
	HMENU hMenu;
	POINT ptCurrent;

    /* Get MEM_POPUP from resource */

	hMenu=LoadMenu(GetModule()->hInstance, "MEM_POPUP");

    /* Then get the first (and last popup) of the menu */

    hMenu=GetSubMenu(hMenu, 0);

	EnableMenuItem(hMenu, CM_POPUP_PASTE, isClipboard ? MF_ENABLED : MF_GRAYED);

	ptCurrent = MAKEPOINT(Msg.LParam);
	ClientToScreen(HWindow, &ptCurrent);
	TrackPopupMenu(hMenu, TPM_LEFTALIGN, ptCurrent.x, ptCurrent.y, 0, HWindow, NULL);
}


void TFrqIndicator::WMNChitTest(RTMessage Msg)
{}

