/*===========================================================================

   FTW Application routine

   $ Version 3.1  10/09/93  23:10:59 $ 

   Copyright 1990, 1993 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not        
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is          
   for no cost.                                                            
                                                                           
===========================================================================*/

#include "ftwapp.h"
#include "ftwdlg.h"

/*******************************************************************

	The Application Name

*******************************************************************/

char ApplicationName[]  = "FTW";

/*******************************************************************

	Create and TftwApplication Object

*******************************************************************/

TftwApp::TftwApp(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) :
		TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};


/*******************************************************************

	Create the Application main window

*******************************************************************/

void TftwApp::InitMainWindow()
{
	MainWindow = new Tftw(NULL, ApplicationName);
}


/*******************************************************************

	Destroy the application and unload font resource

*******************************************************************/

TftwApp::~TftwApp()
{
	RemoveFontResource("FTWFONT.FON");
}

/*******************************************************************

	Called only at the 1st (and last..) instance

*******************************************************************/

void TftwApp::InitInstance()
{
	TApplication::InitInstance();
	HAccTable = LoadAccelerators(hInstance, ApplicationName);
	if(!AddFontResource("FTWFONT.FON"))
	{
		MessageBeep(MB_ICONEXCLAMATION);
		MessageBox(NULL,"Unable to open FTWFONT.FON", "Error", MB_ICONEXCLAMATION | MB_OK);
	}
}

/*******************************************************************

	Process only the Accelerators and Dialog Application Message

*******************************************************************/

BOOL TftwApp::ProcessAppMsg(LPMSG Message)
{
	return ProcessAccels(Message) || ProcessDlgMsg(Message);
}

