/*===========================================================================

   FTW Main Dialog routine

   $ Version 3.1  10/09/93  23:06:36 $ 

   Copyright 1990, 1993 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not        
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is          
   for no cost.                                                            
                                                                           
===========================================================================*/

#include "aboutdlg.h"
#include "freqdlg.h"
#include "ftwdlg.h"
#include "ftwapp.h"
#include "lboxmem.h"
#include "memory.h"
#include "memdlg.h"
#include "offdlg.h"
#include "selstep.h"
#include "setup.h"

#include <strstrea.h>
#include <stdio.h>

/*******************************************************************

	Define the palette of Static Text background

*******************************************************************/

const long RGB_YELLOW = 0x0000FFFFL;


/*******************************************************************

	Overload of ipstream and opstream for MemListBox I/O function

	see OWL reference

*******************************************************************/

__link(RegMemListBoxData)

inline Ripstream operator >> ( Ripstream is, RTMemListBoxData cl )
  { return is >> (RTStreamable)cl; }

inline Ripstream operator >> ( Ripstream is, RPTMemListBoxData cl )
  { return is >> (RPvoid)cl; }

inline Ropstream operator << ( Ropstream os, RTMemListBoxData cl )
  { return os << (RTStreamable)cl; }

inline Ropstream operator << ( Ropstream os, PTMemListBoxData cl )
  { return os << (PTStreamable)cl; }


/*******************************************************************

	Tftw constructor an TDialog descendent

*******************************************************************/

Tftw::Tftw(PTWindowsObject AParent, LPSTR ATitle) :
							TDialog (AParent, ATitle)
{

/*******************************************************************

	Create dinamic object

*******************************************************************/

	PTftwApp Application = (PTftwApp) GetApplication();
	backgroundBitmap = new Bitmap (Application->hInstance,"BACKGROUND");

/*******************************************************************

	Get the default ini filename from the resource
	
*******************************************************************/

	LoadString(GetModule()->hInstance, IDS_DEFAULT_INIFILE,ProfileName, MAXPATH);

/*******************************************************************

	Get the name of the FTW Clipboard Format for registering

*******************************************************************/

    char clipFormat[10];

    LoadString(GetModule()->hInstance, IDS_FTW_CLIP_FMT,clipFormat , sizeof(clipFormat));

    ftwClipboard=RegisterClipboardFormat( clipFormat );

	if(!ftwClipboard)
        	MessageBox(HWindow, "Error registering FTW clipboard format", "Error!", MB_APPLMODAL|MB_ICONSTOP);


/*******************************************************************
	create the config buffer
*******************************************************************/

 	configuration = new TConfigParam;

/*******************************************************************

	Set in RX mode both side

*******************************************************************/

	txStat[0]=txStat[1]=0;

/*******************************************************************

	Don't check bounds to Offset

*******************************************************************/

	offset[0].setCheck(NOCHECKED);
	offset[1].setCheck(NOCHECKED);

/*******************************************************************

	Get number of radio from profile file

*******************************************************************/

	int numOfRadio=GetPrivateProfileInt(ApplicationName,"NumOfRadio",1,ProfileName);

	if (numOfRadio < 1 || numOfRadio > 2)
							numOfRadio = 1;

/*******************************************************************

	set it in the program configuration struct

*******************************************************************/

	configuration->setNumOfRadio(numOfRadio-1);

	char buff[10];

/*******************************************************************

	See if the program must restore the last state

*******************************************************************/

	GetPrivateProfileString(ApplicationName,"RestoreLastState","N",buff,4,ProfileName);
	configuration->setSaveFrq(buff);

/*******************************************************************

	See the memory file name

*******************************************************************/

    char maxPath[MAXPATH], defaultName[MAXPATH];

    LoadString(GetModule()->hInstance, IDS_DEFAULT_MEMFILE,defaultName, MAXPATH);

    GetPrivateProfileString(ApplicationName,"MemoryFilename",defaultName,maxPath,MAXPATH,ProfileName);
	configuration->setMemoryFilename(maxPath);

/*******************************************************************

	See the comport for radio 1

*******************************************************************/

	GetPrivateProfileString("Radio 1","ComPort","COM2",buff,5,ProfileName);
	configuration->setRadio1Com(buff);

/*******************************************************************

	 See the comport for radio 2

*******************************************************************/

	GetPrivateProfileString("Radio 2","ComPort","COM2",buff,5,ProfileName);
	configuration->setRadio2Com(buff);

/*******************************************************************

	See the type of radio 1

*******************************************************************/

	GetPrivateProfileString("Radio 1","Type","FT-212",buff,7,ProfileName);
	configuration->setRadio1Type(buff);

    int radioType = FT712 != stricmp("FT-212", buff);

    frequency[0].setType(radioType);
    memory[0].setType(radioType);

    unsigned long low, high;
    char boundBuff[10];

    radioType++;

    LoadString(GetModule()->hInstance, radioType * IDS_BOUND_BASE , boundBuff, sizeof boundBuff);

    low = atol(boundBuff);

    LoadString(GetModule()->hInstance, radioType * IDS_BOUND_BASE + 1, boundBuff, sizeof boundBuff);

    high = atol(boundBuff);

    frequency[0].setBounds(low, high);

/*******************************************************************

	See the type of radio 2

*******************************************************************/

	GetPrivateProfileString("Radio 2","Type","FT-712",buff,7,ProfileName);
	configuration->setRadio2Type(buff);

    radioType = FT212 != stricmp("FT-712", buff);


    frequency[1].setType(radioType);

	memory[1].setType(radioType);

    radioType++;

    LoadString(GetModule()->hInstance, radioType * IDS_BOUND_BASE , boundBuff, sizeof boundBuff);

    low = atol(boundBuff);

    LoadString(GetModule()->hInstance, radioType * IDS_BOUND_BASE + 1, boundBuff, sizeof boundBuff);

    high = atol(boundBuff);

    frequency[1].setBounds(low, high);

	ifpstream memoryStream (configuration->getMemoryFilename());

/*******************************************************************

	If there isn't the file then ...

*******************************************************************/

	if (!memoryStream)
	{

/*******************************************************************

	Allocate transfer buffer for Memory ListBox

*******************************************************************/

		for (int i=0;i<2;i++)
			memoryBuffer[i].memoryListBox= new TMemListBoxData;


/*******************************************************************

		Assign to memory a default value

*******************************************************************/

		Pchar defaultMem[] = { "145.0000", "435.0000" };

		memoryBuffer[0].numberOfMem=memoryBuffer[1].numberOfMem=0;
		memoryBuffer[0].memoryListBox->AddString(defaultMem[memory[0].getType()]);
		memoryBuffer[1].memoryListBox->AddString(defaultMem[memory[1].getType()]);
	}
	else

/*******************************************************************

		Else load from stream the contents

*******************************************************************/

		for (int i=0;i<2;i++)
			memoryStream >> memoryBuffer[i].memoryListBox;

/*******************************************************************

	Set the other buffer vars

*******************************************************************/

	memoryBuffer[0].numberOfMem=memoryBuffer[0].memoryListBox->Strings->getItemsInContainer();
	memoryBuffer[1].numberOfMem=memoryBuffer[1].memoryListBox->Strings->getItemsInContainer();

	memoryBuffer[0].memSelected=0;
	memoryBuffer[1].memSelected=0;

/*******************************************************************

	Read last state param only if specified in the file

*******************************************************************/

	if(configuration->isSaveFrq())
	{

/*******************************************************************

		See the last side

*******************************************************************/

		int lastSide=GetPrivateProfileInt(ApplicationName,"LastSide",0,ProfileName);

		if (lastSide < 0 || lastSide > 1)
					lastSide = 0;

		side=lastSide;

/*******************************************************************

		Get the last step of radio 1

*******************************************************************/

		int step;

		step=GetPrivateProfileInt("Radio 1","LastStep",0,ProfileName);

		if (step < 0 || step > 4)
					step = 0;

		currentStep[0]=ID_5_KHZ+step;

/*******************************************************************

		Get the last step of radio 2

*******************************************************************/

		step=GetPrivateProfileInt("Radio 2","LastStep",0,ProfileName);

		if (step < 0 || step > 4)
					step = 0;

		currentStep[1]=ID_5_KHZ+step;

/*******************************************************************

		Get the last mode of radio 1

*******************************************************************/

		int lastMode=GetPrivateProfileInt("Radio 1","LastMode",0,ProfileName);

		if (lastMode < VFO || lastMode > MEM)
					lastMode = VFO;

		mode[0]=lastMode;

/*******************************************************************

		Get the last mode of radio 2

*******************************************************************/

		lastMode=GetPrivateProfileInt("Radio 2","LastMode",0,ProfileName);

		if (lastMode < VFO || lastMode > MEM)
					lastMode = VFO;

		mode[1]=lastMode;

/*******************************************************************

		Get the last channel of radio 1

*******************************************************************/

		int channel;

		channel=GetPrivateProfileInt("Radio 1","LastChannel",0,ProfileName);

		if (channel < 0 || channel > memoryBuffer[0].numberOfMem)
								channel = 0;

		memory[0].setChannel(channel);

		memoryBuffer[0].memSelected=channel;

/*******************************************************************

		Get the last channel of radio 2

*******************************************************************/

		channel=GetPrivateProfileInt("Radio 2","LastChannel",0,ProfileName);

		if (channel < 0 || channel > memoryBuffer[1].numberOfMem)
								channel = 0;

		memory[1].setChannel(channel);

		memoryBuffer[1].memSelected=channel;

/*******************************************************************

		Get the last offset of radio 1

*******************************************************************/

		int lastOffset;

		lastOffset=GetPrivateProfileInt("Radio 1","LastOffset",0,ProfileName);

		if (lastOffset < 0 || lastOffset > 2)
					lastOffset = 0;

		currentOffset[0]=lastOffset;

/*******************************************************************

		Get the last offset of radio 2

*******************************************************************/

		lastOffset=GetPrivateProfileInt("Radio 2","LastOffset",0,ProfileName);

		if (lastOffset < 0 || lastOffset > 2)
					lastOffset = 0;

		currentOffset[1]=lastOffset;


/*******************************************************************

		Get the last frequency of radio 1

*******************************************************************/

		unsigned long frq;

		GetPrivateProfileString("Radio 1","LastFrequency","14500000",buff,9,ProfileName);

		frq=atol(buff);

		frequency[0]=frq;


/*******************************************************************

		Get the offset value of radio 1

*******************************************************************/


		GetPrivateProfileString("Radio 1","Offset","00000000",buff,9,ProfileName);

		frq=atol(buff);

		if (frq <= 0L || frq > 3000000L)
					frq=0L;

		offset[0]=frq;

/*******************************************************************

		Get the last frequency of radio 2

*******************************************************************/

		GetPrivateProfileString("Radio 2","LastFrequency","43500000",buff,9,ProfileName);

		frq=atol(buff);

		frequency[1]=frq;

/*******************************************************************

		Get the offset value of radio 2

*******************************************************************/

		GetPrivateProfileString("Radio 2","Offset","00000000",buff,9,ProfileName);

		frq=atol(buff);

		if (frq <= 0L || frq > 3000000L)
					frq=0L;

		offset[1]=frq;

        }
/*******************************************************************

	else set the default value

*******************************************************************/

	else
	{
		unsigned long defaultFreq[] = { 14500000L, 43500000L };

		currentStep[0]=currentStep[1]=ID_5_KHZ;
		side=0;
		mode[0]=mode[1]=VFO;
		frequency[0]=defaultFreq[memory[0].getType()];
		frequency[1]=defaultFreq[memory[1].getType()];
		currentOffset[0]=currentOffset[1]=0; // Simplex
		memory[0].setChannel(0);
		memory[1].setChannel(0);
	}

	memory[0].setFrequency((Pchar)(PCchar)(RString)(*memoryBuffer[0].memoryListBox->Strings)[memory[0].channel()]);
	memory[1].setFrequency((Pchar)(PCchar)(RString)(*memoryBuffer[1].memoryListBox->Strings)[memory[1].channel()]);

/*******************************************************************

	Open com's calling the TFtwCom constructor

*******************************************************************/

	outPort = new TFtwCom(numOfRadio, configuration->getRadio1Com(), configuration->getRadio1Com());

    int i;

	if((i=outPort->openCom()) > 0)
	{

/*******************************************************************

	If there is some error

*******************************************************************/

        char dummy[30];
		ostrstream message(dummy, sizeof(dummy));
		Pchar msg[] = { "", "opening", "setting up" };

		message.flush();
		message << "Error " << (Pchar) msg [i] << " COM port ";
		MessageBox(HWindow, message.str(), "Error!", MB_APPLMODAL|MB_ICONSTOP);
	}
	else
		catOn();

/*******************************************************************

	No active popup at startup...

********************************************************************/

  	activePopup=-1;


/*******************************************************************

	Load menu from resource

*******************************************************************/

	for(i = 0 ; i < 2 ; i++ )
    	ftwMenu[i]=LoadMenu(Application->hInstance, (LPSTR) MAKEINTRESOURCE(i+1));

}

/*******************************************************************

	Delete the Tftw Object

*******************************************************************/

Tftw::~Tftw()
{
	delete configuration;
	delete backgroundBitmap;
	delete outPort;

	for (int i=0; i<2; i++)
    {
        delete frqIndicator[i];
		delete memoryBuffer[i].memoryListBox;
    }

	Destroy();
}
/*******************************************************************

	Return the className ("FTW")

*******************************************************************/

LPSTR Tftw::GetClassName()
{
	return ApplicationName;
}

/*******************************************************************

	Compile WindowClass

*******************************************************************/


void Tftw::GetWindowClass(WNDCLASS& AWndClass)
{

/*******************************************************************

	Call the default function

*******************************************************************/

	TDialog::GetWindowClass(AWndClass);
	ftwIcon=AWndClass.hIcon = LoadIcon(GetApplication()->hInstance, ApplicationName);
}

/*******************************************************************

	Respond to MENU Close Message

*******************************************************************/

void Tftw::CMExit(RTMessage)
{
	Exit();
}

/*******************************************************************

	Respond to Accelerator Close Message

*******************************************************************/

void Tftw::AccExit(RTMessage)
{
	Exit();
}


/*******************************************************************

	Paint the Dialog every time it is move or overlapped from
	another window

*******************************************************************/

void Tftw::WMPaint(RTMessage)
{

	PAINTSTRUCT PS;

	BeginPaint(HWindow, &PS);
	backgroundBitmap->Display(PS.hdc, 0, 0);
	EndPaint(HWindow, &PS);
}


/*******************************************************************

	Show appropriate Title control in the menu and button

*******************************************************************/

void Tftw::showControl()
{

	Pchar toggleModeStr[] = { "&Memory Mode", "&VFO Mode" };
	Pchar toggleSideStr[] = { "&Left Side", "&Right Side" };

	HMENU hMenu;
	hMenu = GetMenu(HWindow);

	ModifyMenu(hMenu,CM_TOGGLEMODE, MF_BYCOMMAND|MF_STRING, CM_TOGGLEMODE, toggleModeStr[((mode[side]+1) & 1)]);
	ModifyMenu(hMenu,CM_TOGGLESIDE, MF_BYCOMMAND|MF_STRING, CM_TOGGLESIDE, toggleSideStr[((side+1) & 1)]);
}


/*******************************************************************

	Switch between the mode ( VFO / MEMORY )

*******************************************************************/

void Tftw::CMToggleMode(RTMessage)
{
	++mode[side] &= 1;
	showMode();
    showControl();

	if(!mode[side])
	{
		showMemory();
		setMemory();
	}
	else
	{
		showStep();
		setFrequency();
	}
}

/*******************************************************************

	Toggle side (Left / Right)

*******************************************************************/

void Tftw::CMToggleSide(RTMessage)
{
	++side &= 1;
	showControl();
	toggleSideButton();
}

/*******************************************************************

	Respond to an TX/RX Button Message

*******************************************************************/

void Tftw::IDTrx(RTMessage)
{
	txStat[side]++;
	txStat[side]&=1;
	if(!configuration->numOfRadio())
		txStat[(side+1) & 1] = txStat[side];
	TX_RX();
}

/*******************************************************************

	Respond to an TX/RX Menu Message

*******************************************************************/

void Tftw::CMTrx(RTMessage)
{
	txStat[side]++;
	txStat[side]&=1;
	if(!configuration->numOfRadio())
		txStat[(side+1) & 1] = txStat[side];
	TX_RX();
}


void Tftw::catOn()
{

/*******************************************************************

	First save the actual side

*******************************************************************/

        char actualSide=side;


/*******************************************************************

	Then activate CAT on both side

*******************************************************************/

	for(int i=0;i<2;i++)
	{
		side=i;
		outPort->comFunct(side, 0);
		qsy();
	}
        side=actualSide;
}

/*******************************************************************

	Disable CAT for each radios

*******************************************************************/

void Tftw::catOff()
{
	for(int i=0; i < 2; i++)
	{
		outPort->comFunct(i,1);
	}
}

/*******************************************************************

	Show the current Step on the Main Dialog

*******************************************************************/

void Tftw::showStep()
{
	Pchar stepStr[] = { "5 Khz", "10 Khz", "12.5 Khz", "20 Khz", "25 Khz" };

	SetDlgItemText(HWindow, ID_STEP_MEM, stepStr[currentStep[side]-ID_STEP]);
}

/*******************************************************************

	Show the memroy Channel in the Main Dialog

*******************************************************************/

void Tftw::showMemory()
{
	char temp[10];

	sprintf(temp," CH %02i", memory[side].channel());
	SetDlgItemText(HWindow, ID_STEP_MEM, temp);
}


/*******************************************************************

	Set the frequency value in the current side slot

*******************************************************************/

void Tftw::setFrequency()
{
	frqIndicator[side]->SetText(frequency[side]);
	qsy();
}
/*******************************************************************

	Set the memory value in the current side slot

*******************************************************************/

void Tftw::setMemory()
{
	frqIndicator[side]->SetText(memory[side]);
	qsy();
}

/*******************************************************************

	Init the main Dialog setting the appropriate defaults

*******************************************************************/

// void Tftw::WMInitDialog(RTMessage msg)

void Tftw::SetupWindow()
{

	SetMenu(HWindow, ftwMenu[mode[side]]);


/*******************************************************************

	Link the frequency indicator

*******************************************************************/

	frqIndicator[0] = new TFrqIndicator(this, ID_LEFT_FRQ, 10, ftwClipboard);
	frqIndicator[1] = new TFrqIndicator(this, ID_RIGHT_FRQ, 10, ftwClipboard);

	toggleSideButton();

	if(!mode[side])
	{
		SetWindowText(GetDlgItem(HWindow,ID_LEFT_FRQ), (memory[0]));
		SetWindowText(GetDlgItem(HWindow,ID_RIGHT_FRQ),(memory[1]));
		showMemory();
	}
	else
	{
		SetWindowText(GetDlgItem(HWindow,ID_LEFT_FRQ), (frequency[0]));
		SetWindowText(GetDlgItem(HWindow,ID_RIGHT_FRQ),(frequency[1]));
		showStep();
	}

    showMode();

	showControl();

	showOffset();

	qsy();

//	TDialog::WMInitDialog(msg);
    TDialog::SetupWindow();

}


/*******************************************************************

	Toggle the control status

*******************************************************************/

void Tftw::toggleSideButton()
{
	SendDlgItemMsg(ID_SIDE_CTL+((side + 1) & 1),BM_SETSTATE, (side) ? ((side + 1) & 1) : side ,0);
	SendDlgItemMsg(ID_SIDE_CTL+side,BM_SETSTATE, (side) ? side : ((side + 1) & 1), 0);


	SetDlgItemText(HWindow, ID_SIDE_CTL+((side + 1) & 1), (side) ? (((side + 1) & 1) ? "MAIN" : "SUB") : "SUB" );
	SetDlgItemText(HWindow, ID_SIDE_CTL+side , (side) ? "MAIN" : (((side + 1) & 1) ? "MAIN" : "SUB"));

    showMode();

	showControl();

	if(!mode[side])
	{
		setMemory();
		showMemory();
	}
	else
	{
		setFrequency();
		showOffset();
		showStep();
	}
}


/*******************************************************************

	Show the current offset

*******************************************************************/

void Tftw::showOffset()
{
	Pchar offsetStr[] = { "S", "-", "+" };
	SetDlgItemText(HWindow, ID_OFFSET, offsetStr[currentOffset[side]]);
}

/*******************************************************************

	Respond to WM_CLOSE Message

*******************************************************************/

void Tftw::WMClose(RTMessage)
{
	Exit();
}


/*******************************************************************

	Create a Modify Step Dialog

*******************************************************************/

void Tftw::modifyStep(RTMessage)
{
	GetApplication()->ExecDialog(new TSetStepDialog(this ,"STEPDIALOG", &currentStep[side]));
	showStep();
}

/*******************************************************************

	Create a List Memory Dialog

*******************************************************************/

void Tftw::listMemory()
{
   GetApplication()->ExecDialog(new TMemoryDialog(this ,"MEMORY", memoryBuffer[side], ftwClipboard));
   int selected=memoryBuffer[side].memSelected;

/*******************************************************************

	If some memory was selected then validate and copy it to the
	current side.

*******************************************************************/


   if (selected >= 0 && selected < memoryBuffer[side].numberOfMem)
   {
	memory[side].setChannel(selected);

	char temp[11];
	memoryBuffer[side].memoryListBox->GetSelString(temp, sizeof temp);
	memory[side].setFrequency(temp);
	showMemory();
	setMemory();
   }
}


/*******************************************************************

	Setup main dialog with the appropriate defaults

*******************************************************************/

void Tftw::setupDialog(RTMessage)
{
	GetApplication()->ExecDialog(new TSetupDialog(this ,"SETUP", configuration));

	catOff();

	if(outPort->closeCom())
	{
			char dummy[30];
			ostrstream message(dummy, sizeof(dummy));

			message.flush();
			message << "Error closing COMPORT";
			MessageBox(HWindow, message.str(), "Error!", MB_APPLMODAL|MB_ICONSTOP);
	}

	outPort->setParam(configuration->numOfRadio(), configuration->getRadio1Com(), configuration->getRadio1Com());

    int i;

	if((i=outPort->openCom()) > 0)
	{
		char dummy[30];
		ostrstream message(dummy, sizeof(dummy));

		Pchar msg[] = { "", "opening", "setting up" };

		message.flush();
		message << "Error " << (Pchar)msg[i] << " COMPORT";
		MessageBox(HWindow, message.str(), "Error!", MB_APPLMODAL|MB_ICONSTOP);
	}
	else
		catOn();
}

/*******************************************************************

	Toggle between VFO and MEMORY Mode

*******************************************************************/

void Tftw::toggleMode(RTMessage)
{
	++mode[side] &= 1;

    showMode();

	showControl();

	if(!mode[side])
	{
		showMemory();
		setMemory();
	}
	else
	{
		showStep();
		setFrequency();
	}

}

/*******************************************************************

	Show the current mode in the currente side

*******************************************************************/

void Tftw::showMode()
{
	Pchar modeStr[] = { "VFO", "MEM" };

	SetDlgItemText(HWindow, ID_VFOMEM, modeStr[mode[side]]);
	EnableWindow(GetItemHandle(ID_LUP_MHZ), mode[side] ? TRUE : FALSE);
	EnableWindow(GetItemHandle(ID_LDOWN_MHZ), mode[side] ? TRUE : FALSE);
	EnableWindow(GetItemHandle(ID_RUP_MHZ), mode[side] ? TRUE : FALSE);
	EnableWindow(GetItemHandle(ID_RDOWN_MHZ), mode[side] ? TRUE : FALSE);
	EnableWindow(GetItemHandle(ID_OFFSET), mode[side] ? TRUE : FALSE);

    HMENU hMenu;

	hMenu = GetMenu(HWindow);
    
    if(hMenu != ftwMenu[mode[side]])
    	SetMenu(HWindow, ftwMenu[mode[side]]);
}

/*******************************************************************

	Execute the Input frequency Dialog

*******************************************************************/

void Tftw::frequencyDialog()
{
	strcpy(changeFreqBuffer.theFrequency,frequency[side]);
	GetApplication()->ExecDialog(new TFrequencyDialog(this ,"FREQUENCY", changeFreqBuffer));
	frequency[side] = changeFreqBuffer.theFrequency;
	setFrequency();
}

/*******************************************************************

	Execute the Offset frequency Dialog

*******************************************************************/

void Tftw::offsetDialog(RTMessage)
{
	strcpy(changeOffsetBuffer.theOffset,offset[side]);
	currentOffset[side]+=ID_SIMPLEX;
	GetApplication()->ExecDialog(new TOffsetDialog(this ,"OFFSET", changeOffsetBuffer, &currentOffset[side]));
	offset[side]=changeOffsetBuffer.theOffset;
	currentOffset[side]-=ID_SIMPLEX;
	showOffset();
}

/*******************************************************************

	Respond to the WMControlColor.
	This function is called from Windows when paint the various
	control.

*******************************************************************/

void Tftw::WMControlColor(RTMessage Msg)
{
	switch (Msg.LP.Hi)
	{
		case CTLCOLOR_BTN:
			Msg.Result = (LRESULT)GetStockObject(NULL_BRUSH);
			break;
		case CTLCOLOR_EDIT:
		case CTLCOLOR_STATIC:
			SetTextColor((HDC)Msg.WParam, RGB_YELLOW);
			SetBkMode((HDC)Msg.WParam, TRANSPARENT);
			Msg.Result = (LRESULT)GetStockObject(BLACK_BRUSH);
			break;
		case CTLCOLOR_DLG:
			SetBkMode((HDC)Msg.WParam, TRANSPARENT);
			Msg.Result = (LRESULT)GetStockObject(NULL_BRUSH);
			break;
		default:
			DefWndProc(Msg);
	}
}

/*******************************************************************

	Exit function.

*******************************************************************/

void Tftw::Exit(void)
{

/*******************************************************************

	Ehi!

*******************************************************************/

	MessageBeep(0);

/*******************************************************************

	Are you sure?

*******************************************************************/

	if (IDYES==MessageBox(HWindow,"Do you really want to quit?","Quit",MB_YESNO|MB_ICONQUESTION))
	{

/*******************************************************************

		Ok, you want to quit.

		Write MemListBox data to Memory Container file

*******************************************************************/

		ofpstream memoryStream (configuration->getMemoryFilename());
        
		if (!memoryStream)
        {
			char dummy[30];
			ostrstream message(dummy, sizeof(dummy));

			message.flush();
			message << "Error writing memory file!";
			MessageBox(HWindow, message.str(), "Error!", MB_APPLMODAL|MB_ICONSTOP);
		}
		else
			for(int i=0;i<2;i++)
				memoryStream << memoryBuffer[i].memoryListBox;

        memoryStream.close();

/*******************************************************************

		And now write all the configuration param in the
		profile file

*******************************************************************/

		char buff[10];

		itoa(configuration->numOfRadio()+1,buff,10);
		WritePrivateProfileString(ApplicationName,"NumOfRadio",buff,ProfileName);

		configuration->setSaveFrqString(buff);
		WritePrivateProfileString(ApplicationName,"RestoreLastState",buff,ProfileName);

		WritePrivateProfileString(ApplicationName,"MemoryFilename",configuration->getMemoryFilename(),ProfileName);

		itoa(side,buff,10);
		WritePrivateProfileString(ApplicationName,"LastSide",buff,ProfileName);

		itoa(mode[0],buff,10);
		WritePrivateProfileString("Radio 1","LastMode",buff,ProfileName);

		itoa(mode[1],buff,10);
		WritePrivateProfileString("Radio 2","LastMode",buff,ProfileName);

		WritePrivateProfileString("Radio 1","ComPort",configuration->getRadio1Com(),ProfileName);
		WritePrivateProfileString("Radio 1","Type",configuration->getRadio1Type(),ProfileName);

		ultoa(frequency[0].value(),buff,10);
		WritePrivateProfileString("Radio 1","LastFrequency",buff,ProfileName);

		ultoa(offset[0].value(),buff,10);
		WritePrivateProfileString("Radio 1","Offset",buff,ProfileName);

		itoa(currentStep[0]-ID_5_KHZ,buff,10);
		WritePrivateProfileString("Radio 1","LastStep",buff,ProfileName);

		itoa(currentOffset[0],buff,10);
		WritePrivateProfileString("Radio 1","LastOffset",buff,ProfileName);

		itoa(memory[0].channel(),buff,10);
		WritePrivateProfileString("Radio 1","LastChannel",buff,ProfileName);

		WritePrivateProfileString("Radio 2","ComPort",configuration->getRadio2Com(),ProfileName);
		WritePrivateProfileString("Radio 2","Type",configuration->getRadio2Type(),ProfileName);

		ultoa(frequency[1].value(),buff,10);
		WritePrivateProfileString("Radio 2","LastFrequency",buff,ProfileName);

		ultoa(offset[1].value(),buff,10);
		WritePrivateProfileString("Radio 2","Offset",buff,ProfileName);

		itoa(currentStep[1]-ID_5_KHZ,buff,10);
		WritePrivateProfileString("Radio 2","LastStep",buff,ProfileName);

		itoa(currentOffset[1],buff,10);
		WritePrivateProfileString("Radio 2","LastOffset",buff,ProfileName);

		itoa(memory[1].channel(),buff,10);
		WritePrivateProfileString("Radio 2","LastChannel",buff,ProfileName);

		catOff();

		if(outPort->closeCom())
		{
			char dummy[30];
			ostrstream message(dummy, sizeof(dummy));

			message.flush();
			message << "Error closing COMPORT";
			MessageBox(HWindow, message.str(), "Error!", MB_APPLMODAL|MB_ICONSTOP);
		}

/*******************************************************************

		And call the default function

*******************************************************************/

		ShutDownWindow();
	}

}

void Tftw::ShutDownWindow()
{
	for (int i=0; i<2; i++)
        DestroyMenu(ftwMenu[i]);
  

	DestroyIcon(ftwIcon);
	TDialog::ShutDownWindow();
}

/*******************************************************************

	Show the About Modal Dialog

*******************************************************************/

void Tftw::About(RTMessage)
{
	GetApplication()->ExecDialog(new TAboutDialog(this, "ABOUT"));
}

/*******************************************************************

	Set the frequency in the current side

*******************************************************************/

void Tftw::qsy()
{
	char tempFrq[10];
	static char cmd[6];
	char frequenza[] = "00000000";

	if(mode[side])
		strcpy(tempFrq,frequency[side]);
	else
		strcpy(tempFrq,memory[side]);

	for (int i=0,j=0; i<8;i++)
	{
		if(i==3) continue;
		frequenza[j++]=tempFrq[i];
	}

	int a,b;
	Pchar s;
	Pchar d;

	s=frequenza; d=cmd;

	while(*s)
	{
		a = *s++ - '0';
		b= *s++ - '0';

		*d++ = ( a * 16 ) + b;
	}

	*d++=1;
	*d=NULL;

	outPort->sendCom(side, cmd, 5);
}


