/*===========================================================================

   FTW Main Dialog header

   $ Version 3.0  23/10/92  21:58:36 $ 

   Copyright 1990, 1992 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not        
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is          
   for no cost.                                                            
                                                                           
===========================================================================*/

#ifndef __FTWDLG_H
#define __FTWDLG_H

#include "bitmap.h"
#include "buffers.h"
#include "config.h"
#include "comm.h"
#include "freq.h"
#include "ftwid.h"
#include "memory.h"
#include "frqind.h"

#include <dir.h>

_CLASSDEF(Tftw)
class Tftw : public TDialog
{
public:
	Tftw(PTWindowsObject AParent, LPSTR ATitle);
	~Tftw();

private:

	enum { VFO, MEM };
    enum { RIGHT, LEFT };
	
	int txStat[2];
	int lastTxStat[2];
	int currentStep[2];
    int currentOffset[2];

	TChangeFreqBuffer changeFreqBuffer;
	TChangeOffsetBuffer changeOffsetBuffer;

	TMemoryBuffer memoryBuffer[2];

	Bitmap *backgroundBitmap;

    Frequency frequency[2];
	Frequency offset[2];
    Memory	memory[2];

	HMENU ftwMenu[2];
    HICON ftwIcon;

	unsigned int ftwClipboard;

	PTFrqIndicator frqIndicator[2];

	char side;	// Operating side (Left of Right)
	char mode[2];	// Operating mode (VFO or Memory)

    char activePopup; // active popup 0 Left 1 Right -1 None

	PTConfigParam configuration;
	PTFtwCom outPort;

    char ProfileName[MAXPATH];

    void showStep();
	void showOffset();
	void showMode();
	void showMemory();

	void showControl();

	void catOn();
	void catOff();
	void qsy();
	void TX_RX();
	void toggleSideButton();
	void setFrequency();
	void setMemory();

	void Exit(void);

	void downMhz();
	void upMhz();


// 	TDialog overload function

	virtual LPSTR GetClassName();
	virtual void GetWindowClass(WNDCLASS& AWndClass);
    virtual void ShutDownWindow();
    virtual void SetupWindow();

// DDVT for Tftw

	virtual void IDUp()     					= [ID_FIRST + ID_UP_STEP];
	virtual void IDDown()   					= [ID_FIRST + ID_DOWN_STEP];
	virtual void IDLUpMhz(RTMessage)     		= [ID_FIRST + ID_LUP_MHZ];
	virtual void IDLDownMhz(RTMessage)   		= [ID_FIRST + ID_LDOWN_MHZ];
	virtual void IDRUpMhz(RTMessage)     		= [ID_FIRST + ID_RUP_MHZ];
	virtual void IDRDownMhz(RTMessage)   		= [ID_FIRST + ID_RDOWN_MHZ];
	virtual void IDToggleSide(RTMessage) 		= [ID_FIRST + ID_TOGGLE_FRQ];
	virtual void IDLeftSide(RTMessage)   		= [ID_FIRST + ID_LEFT_CTL];
	virtual void IDRightSide(RTMessage)  		= [ID_FIRST + ID_RIGHT_CTL];
	virtual void IDOffset(RTMessage)     		= [ID_FIRST + ID_OFFSET];
	virtual void modifyStep(RTMessage)   		= [CM_FIRST + CM_FTSETSTEP];
	virtual void setupDialog(RTMessage)  		= [CM_FIRST + CM_FTSETUP];
	virtual void About(RTMessage) 	     		= [CM_FIRST + CM_FTABOUT];
	inline 	virtual void CMExit(RTMessage)  	= [CM_FIRST + CM_EXIT];
	inline 	virtual void AccExit(RTMessage) 	= [ID_FIRST + CM_EXIT];
	inline	virtual void WMClose(RTMessage Msg) = [WM_FIRST + WM_CLOSE];
    virtual void WMPaint(RTMessage Msg) 		= [WM_FIRST + WM_PAINT];
	virtual void WMControlColor (RTMessage) 	= [WM_FIRST + WM_CTLCOLOR ];
	// virtual void WMInitDialog(RTMessage) 		= [WM_FIRST + WM_INITDIALOG];
	virtual void frequencyDialog() 				= [CM_FIRST + CM_FREQUENCY];
	virtual void offsetDialog(RTMessage) 		= [CM_FIRST + CM_OFFSET];
	virtual void IDTrx(RTMessage)				= [ID_FIRST + ID_TRX];
    virtual void CMTrx (RTMessage)				= [CM_FIRST + CM_FTTRX];
	virtual void listMemory() 					= [CM_FIRST + CM_LISTMEMORY];
	virtual void toggleMode(RTMessage) 			= [ID_FIRST + ID_VFOMEM];
	virtual void CMToggleMode(RTMessage) 		= [CM_FIRST + CM_TOGGLEMODE];
	virtual void CMToggleSide(RTMessage) 		= [CM_FIRST + CM_TOGGLESIDE];
	virtual void CMFTHelp(RTMessage) 			= [CM_FIRST + CM_FTHELP];

	virtual void popupEdit() 					= [CM_FIRST + CM_POPUP_EDIT];
	virtual void popupCopy(RTMessage) 			= [CM_FIRST + CM_POPUP_COPY];
    virtual void popupPaste(RTMessage) 			= [CM_FIRST + CM_POPUP_PASTE];
    virtual void popupInc() 					= [CM_FIRST + CM_POPUP_INC];
    virtual void popupDec() 					= [CM_FIRST + CM_POPUP_DEC];
	virtual void WMActivePopup(RTMessage Msg)   = [WM_FIRST + WM_ACTIVE_POPUP];

};

#endif  // __FTWDLG_HPP
