/*===========================================================================

   FTW PopUp Menu message handler routine
   
   $ Version 3.1  10/09/93  23:05:46 $ 

   Copyright 1990, 1993 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not        
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is          
   for no cost.                                                            
                                                                           
===========================================================================*/

#include "ftwdlg.h"
#include "freqdlg.h"
#include "memdlg.h"
#include <stdio.h>

void Tftw::popupEdit()
{
	if(mode[activePopup]!=VFO)
    {
    	strcpy(changeFreqBuffer.theFrequency,frequency[activePopup].string());
		GetApplication()->ExecDialog(new TFrequencyDialog(this ,"FREQUENCY", changeFreqBuffer));
		frequency[activePopup] = changeFreqBuffer.theFrequency;
		frqIndicator[activePopup]->SetText(frequency[activePopup]);
	}
	else
    {

	   GetApplication()->ExecDialog(new TMemoryDialog(this ,"MEMORY", memoryBuffer[activePopup], ftwClipboard));
   	   int selected=memoryBuffer[activePopup].memSelected;

   	   if (selected >= 0 && selected < memoryBuffer[activePopup].numberOfMem)
   	   {
			memory[activePopup].setChannel(selected);

			char temp[11];
			memoryBuffer[activePopup].memoryListBox->GetSelString(temp, sizeof temp);
			memory[activePopup].setFrequency(temp);
			
			sprintf(temp," CH %02i", memory[side].channel());
			SetDlgItemText(HWindow, ID_STEP_MEM, temp);
			frqIndicator[activePopup]->SetText(memory[activePopup]);

	   }
    }
}

void Tftw::WMActivePopup(RTMessage Msg)
{
    if(Msg.LParam)
		activePopup=Msg.WParam-ID_SIDE;
}


void Tftw::popupCopy(RTMessage)
{

    char temp[10];

	if(mode[activePopup]!=VFO)
        strcpy(temp,frequency[activePopup]);
    else
    	strcpy(temp,memory[activePopup]);

    strcat(temp, "\n");

    HANDLE StringGlobalHandle;
    LPSTR StringGlobalPtr;

    StringGlobalHandle = GlobalAlloc (GMEM_MOVEABLE,
                           (LONG)lstrlen(temp) + 1);

    if (StringGlobalHandle)
    { 
     	StringGlobalPtr = (Pchar)GlobalLock(StringGlobalHandle);

     	if (StringGlobalPtr)
        {
       		lstrcpy(StringGlobalPtr, temp);
       		GlobalUnlock(StringGlobalHandle);

       		if (OpenClipboard(HWindow))
            {
        		EmptyClipboard();
        		SetClipboardData(CF_TEXT, StringGlobalHandle);
                
                SetClipboardData(ftwClipboard, StringGlobalHandle);

        		CloseClipboard();
        		return ; 
            } 
       		else
				GlobalFree(StringGlobalHandle);
     	}
     	else
			GlobalFree(StringGlobalHandle);
    }

    return;

}

void Tftw::popupPaste(RTMessage)
{
	char temp [10];

	HANDLE StringGlobalHandle;
    LPSTR StringGlobalPtr;
    
    if (OpenClipboard(HWindow))
    {
    	if (IsClipboardFormatAvailable(ftwClipboard))
        {
       		StringGlobalHandle = GetClipboardData(ftwClipboard);

       		if (StringGlobalHandle)
            {
        		StringGlobalPtr = (LPSTR) GlobalLock(StringGlobalHandle);

        		if (StringGlobalPtr)
                {
                    LPSTR i=StringGlobalPtr;
                    Pchar d=temp;


                   	while(*i && *i != '\n')
                    				*d++=*i++;

                    *d=NULL;

                    GlobalUnlock(StringGlobalHandle);
 				}
            }
		}
        CloseClipboard();
    }

    char lastSide=side;
    side=activePopup;

    if (StringGlobalHandle)
    {
    	if(mode[activePopup]!=VFO)
        {
            strcpy(frequency[activePopup], temp);
    		setFrequency();
        }
    	else
        {
    		strcpy(memory[activePopup], temp);
	        setMemory();
        }
    }

	side=lastSide;

}


void Tftw::popupInc()
{
	char lastSide=side;
    side=activePopup;

    IDUp();

    side=lastSide;
}

void Tftw::popupDec()
{
	char lastSide=side;
    side=activePopup;

    IDDown();

    side=lastSide;
}


