/*===========================================================================

   FTW Main Dialog routine

   $ Version 3.1  10/09/93  23:06:23 $ 

   Copyright 1990, 1993 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not        
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is
   for no cost.                                                            
                                                                           
===========================================================================*/

#include "ftwdlg.h"

/*******************************************************************

	Respond to an DOWN message

*******************************************************************/

void Tftw::IDDown()
{

/*******************************************************************

	If we are in vfo mode then decrease the frequency

*******************************************************************/

	if(mode[side])
	{
		frequency[side].down( currentStep[side] - ID_STEP );
		setFrequency();
	}

/*******************************************************************

	else decrease the memory channel

*******************************************************************/

	else
	{
		memoryBuffer[side].memSelected--;

		if (memoryBuffer[side].memSelected < 0 )
			memoryBuffer[side].memSelected=memoryBuffer[side].numberOfMem-1;

		memory[side].setChannel(memoryBuffer[side].memSelected);
		memory[side].setFrequency((Pchar)(PCchar)(RString)(*memoryBuffer[side].memoryListBox->Strings)[memory[side].channel()]);
		showMemory();
		setMemory();
	}
}
/*******************************************************************

	Respond to an UP MHZ Message from the Left Side UP Button

*******************************************************************/

void Tftw::IDLUpMhz(RTMessage)
{
	upMhz();
}

/*******************************************************************

	Respond to an UP MHZ Message from the Right Side UP Button

*******************************************************************/

void Tftw::IDRUpMhz(RTMessage)
{
	upMhz();
}


/*******************************************************************

	Increase the frequency by 1 Mhz

*******************************************************************/

void Tftw::upMhz()
{
	frequency[side] += 100000L;
	setFrequency();
}

/*******************************************************************

	Respond to an DOWN MHZ Message from the Left Side DOWN Button

*******************************************************************/

void Tftw::IDLDownMhz(RTMessage)
{
	downMhz();
}


/*******************************************************************

	Respond to an DOWN MHZ Message from the Right Side DOWN Button

*******************************************************************/

void Tftw::IDRDownMhz(RTMessage)
{
	downMhz();
}

/*******************************************************************

	Decrease the frequency by 1 Mhz

*******************************************************************/

void Tftw::downMhz()
{
	frequency[side] -= 100000L;
	setFrequency();
}

/*******************************************************************

	Respond to toggle side message

*******************************************************************/


void Tftw::IDToggleSide(RTMessage)
{
	(++side) &=1;
	toggleSideButton();
}


/*******************************************************************

	Turn the contron to left side

*******************************************************************/

void Tftw::IDLeftSide(RTMessage)
{
	side=0;
	toggleSideButton();

}


/*******************************************************************

	Turn the contron to right side

*******************************************************************/

void Tftw::IDRightSide(RTMessage)
{
	side=1;
	toggleSideButton();
}

/*******************************************************************

	Respond to a Offset Change Button Control

*******************************************************************/

void Tftw::IDOffset(RTMessage)
{

	currentOffset[side]++;
	if (currentOffset[side] > 2)
				currentOffset[side]=0;

	showOffset();
}

/*******************************************************************

	Respond to an UP message

*******************************************************************/

void Tftw::IDUp()
{

	if (mode[side])
	{
		frequency[side].up( currentStep[side] - ID_STEP );
		setFrequency();
	}

/*******************************************************************

	else increase the memory channel

*******************************************************************/

	else
	{
		memoryBuffer[side].memSelected++;

		if (memoryBuffer[side].memSelected > memoryBuffer[side].numberOfMem - 1)
			memoryBuffer[side].memSelected=0;

		memory[side].setChannel(memoryBuffer[side].memSelected);
		memory[side].setFrequency((Pchar)(PCchar)(RString)(*memoryBuffer[side].memoryListBox->Strings)[memory[side].channel()]);
		showMemory();
		setMemory();
	}
}

/*******************************************************************

	Toggle between TX and RX state

*******************************************************************/

void Tftw::TX_RX()
{

/*******************************************************************

	If something change..

*******************************************************************/


	if (lastTxStat[side] != txStat[side])
	{

/*******************************************************************

	Check if there is only 1 radio ...

*******************************************************************/

	    if(!configuration->numOfRadio())
		lastTxStat[side]=txStat[side]|txStat[((side + 1) & 1)];
	    else
		lastTxStat[side]=txStat[side];

/*******************************************************************

	If there is an offset, then first look at direction the
	modify the frequency before transmit

*******************************************************************/

	    switch (currentOffset[side])
	    {
		case 0:
			break;

		case 1:
			if(offset[side].value() > 0L)
			{
				if(lastTxStat[side])
					frequency[side] -= offset[side];
				else
					frequency[side] += offset[side];

				setFrequency();
			}
			break;

		case 2:
			if(offset[side].value() > 0L)
			{
				if(lastTxStat[side])
					frequency[side] += offset[side];
				else
					frequency[side] -= offset[side];

				setFrequency();
			}
			break;
	    }

		frqIndicator[side]->SetText(frequency[side]);

	    outPort->comFunct(side, 2+lastTxStat[side]);

	}
}
