/*===========================================================================

   FTW Memory ListBox Streamable Buffer code

   $ Version 3.1  10/09/93  23:04:47 $ 

   Copyright 1990, 1993 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not        
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is          
   for no cost.                                                            
                                                                           
===========================================================================*/

#include "lboxmem.h"


/*******************************************************************

	read MemoryListBox data from a stream

*******************************************************************/

Pvoid TMemListBoxData::read(Ripstream is)
{

/*******************************************************************

	Get the SelCount (see TListBoxData)

*******************************************************************/

	is >> SelCount;

	int numOfStrings;

/*******************************************************************

	Get the number of record of SelStrings Object stored

*******************************************************************/

	is >> numOfStrings;


/*******************************************************************

	For each record fill SelStrings object (see TListBoxData)

	do
		read  (record (aString))
		store (record)
	loop

*******************************************************************/

	for ( int i = 0; i < numOfStrings; ++i )
	{
		Pchar p=is.readString();

		SelStrings->add(* new String(p));

		delete p;
	}

/*******************************************************************

	Get the number of record of Strings Object stored

*******************************************************************/

	is >> numOfStrings;

/*******************************************************************

	For each record fill Strings object (see TListBoxData)

	do
		read  (record (aString))
		store (record)
	loop

*******************************************************************/

	for ( i = 0; i < numOfStrings; ++i )
	{
		Pchar p=is.readString();

		Strings->add(*new String(p));

		delete p;
	}

	return this;
}

/*******************************************************************

	write MemoryListBox data to stream

*******************************************************************/

void TMemListBoxData::write(Ropstream os)
{

/*******************************************************************

	Set the SelCount (see TListBoxData)

*******************************************************************/

	os << SelCount;

/*******************************************************************

	Get the number of String in the Array SelString and put
	put it on the stream

*******************************************************************/

	os << SelStrings->getItemsInContainer();

/*******************************************************************

	Create and initialize an Iterator for the Array SelStrings

*******************************************************************/

	RContainerIterator SelStringsIterator = SelStrings->initIterator();

/*******************************************************************

	For each String in the Array SelStrings (see TListBoxData)

	do
		get   (aString)
		store (record)
	loop

*******************************************************************/

	while ( int (SelStringsIterator) != 0 )
	{
		RString theString = (RString) SelStringsIterator++;

		if (theString != NOOBJECT )
				os.writeString(theString);
	}

	delete &SelStringsIterator;

/*******************************************************************

	Get the number of String in the Array String and put
	put it on the stream

*******************************************************************/

	os << Strings->getItemsInContainer();

/*******************************************************************

	Create and initialize an Iterator for the Array Strings

*******************************************************************/

	RContainerIterator StringsIterator = Strings->initIterator();

/*******************************************************************

	For each String in the Array Strings (see TListBoxData)

	do
		get   (aString)
		store (record)
	loop

*******************************************************************/

	while ( int(StringsIterator) != 0 )
	{
		RString theString = (RString) StringsIterator++;
		if (theString != NOOBJECT )
				os.writeString(theString);
	}

	delete &StringsIterator;
}

/*******************************************************************

	create new TMemListBoxData using appropriate constructor

*******************************************************************/

PTStreamable TMemListBoxData::build()
{
	return new TMemListBoxData(streamableInit);
}

/*******************************************************************

	register the TMemListBoxData Object

*******************************************************************/

TStreamableClass RegMemListBoxData("TMemListBoxData",
				TMemListBoxData::build,
				__DELTA(TMemListBoxData));
