/*===========================================================================

   FTW Memory Dialog routine

   $ Version 3.1  10/09/93  23:03:45 $

   Copyright 1990, 1993 by Marco Savegnago.  All rights reserved.
   This software may be freely distributed and used, but it may not
   under any circumstances be sold by anyone other than the author.
   It may be distributed by a commercial company as long as it is
   for no cost.

===========================================================================*/

#include "ftwid.h"
#include "buffers.h"
#include "freq.h"
#include "freqdlg.h"
#include "memdlg.h"

#include <listbox.h>

/*******************************************************************

	Create a Memory Dialog Box

*******************************************************************/

TMemoryDialog::TMemoryDialog(PTWindowsObject AParent, LPSTR AName,
						RTMemoryBuffer buffer, unsigned int ftwClip):\
TDialog(AParent, AName, NULL)
{
	memoryListBox = new TListBox(this, ID_FTMEMORY);
	TransferBuffer=&buffer;

    ftwClipboard=ftwClip;

}

/*******************************************************************

	Process NewMemory Message

*******************************************************************/

void TMemoryDialog::newMem(RTMessage)
{
	TChangeFreqBuffer changeFreqBuffer;

	Frequency temp = 0L;
	temp.setType(FTALL);

	strcpy(changeFreqBuffer.theFrequency,temp.string());
	GetApplication()->ExecDialog(new TFrequencyDialog(this ,"FREQUENCY", changeFreqBuffer));
	temp = changeFreqBuffer.theFrequency;
	if (temp.value() > 0L)
		memoryListBox->AddString(temp.string());

}

/*******************************************************************

	Delete all memory from listbox

*******************************************************************/

void TMemoryDialog::deleteAllMem(RTMessage)

{
	if (memoryListBox->GetCount() <= 0 ||
				memoryListBox->GetSelIndex() < 0)
											return;

/*******************************************************************

	Are you sure?

*******************************************************************/

	if (IDYES==MessageBox(HWindow, "Are you sure?", "Delete All Memory", MB_YESNO|MB_ICONQUESTION))
		memoryListBox->ClearList();
}




/*******************************************************************

	Process deleteMemory Message

*******************************************************************/

void TMemoryDialog::deleteMem(RTMessage)
{
	if (memoryListBox->GetCount() <= 0 ||
				memoryListBox->GetSelIndex() < 0)
											return;

/*******************************************************************

	Are you sure?

*******************************************************************/

	if (IDYES==MessageBox(HWindow, "Are you sure?", "Delete Memory", MB_YESNO|MB_ICONQUESTION))
		memoryListBox->DeleteString(memoryListBox->GetSelIndex());

}


/*******************************************************************

	Process editMemory Message

*******************************************************************/

void TMemoryDialog::editMem(RTMessage)
{

/*******************************************************************

	return directly if there is no memory selected

*******************************************************************/

	if (memoryListBox->GetCount() <= 0 ||
				memoryListBox->GetSelIndex() < 0)
								return;
/*******************************************************************

	Create an exchange buffer

*******************************************************************/

	TChangeFreqBuffer changeFreqBuffer;

	char temp[10];

	memoryListBox->GetSelString(temp,sizeof temp);

	strcpy(changeFreqBuffer.theFrequency,temp);

/*******************************************************************

	Call the Frequency dialog box with the appropriate exchange
	buffer

*******************************************************************/

	GetApplication()->ExecDialog(new TFrequencyDialog(this ,"FREQUENCY", changeFreqBuffer));

/*******************************************************************

	Validate the frequency

*******************************************************************/

	Frequency frq;
	frq.setType(FTALL);
	frq = changeFreqBuffer.theFrequency;

/*******************************************************************

	If it is OK the insert it on the listBox elements Array

*******************************************************************/


	if (frq.value() > 0L)
	{
		memoryListBox->DeleteString(memoryListBox->GetSelIndex());
		memoryListBox->InsertString(frq.string(),memoryListBox->GetSelIndex());
	}

}


/*******************************************************************

	Handle the double click on a listBox item

*******************************************************************/

void TMemoryDialog::HandleMemListBox(RTMessage Msg)
{
	 if ( HIWORD(Msg.LParam) == LBN_DBLCLK )
								CloseWindow(IDOK);
}

/*******************************************************************

	Process OK message

*******************************************************************/


void TMemoryDialog::Ok(RTMessage msg)
{

/*******************************************************************

	Get the number of mem listed

*******************************************************************/

	((PTMemoryBuffer)TransferBuffer)->numberOfMem=memoryListBox->GetCount();

/*******************************************************************

	and the selected memory.

*******************************************************************/

	((PTMemoryBuffer)TransferBuffer)->memSelected=memoryListBox->GetSelIndex();

/*******************************************************************

	then call the TDialog::OK function to swapp the buffer contents

*******************************************************************/

	TDialog::Ok(msg);
}

/*******************************************************************

	Setup Dialog contents

*******************************************************************/

void TMemoryDialog::SetupWindow()
{

/*******************************************************************

	Calling the default Dialog function

*******************************************************************/

	TDialog::SetupWindow();

}

/*******************************************************************

	Copy memory Items to the ClipBoard

*******************************************************************/
void TMemoryDialog::copyMemToClipboard(RTMessage)
{
    if (memoryListBox->GetCount() <= 0 ||
				memoryListBox->GetSelIndex() < 0)
								return;


    CString strContainer;

    char tmp[10];
        
    memoryListBox->GetSelString(tmp,sizeof tmp);

    strContainer += tmp;
	strContainer += "\n";
	
    copyToClipboard(strContainer);
}


void TMemoryDialog::copyAllToClipboard(RTMessage)
{
    int count = memoryListBox->GetCount();

    CString strContainer;

    for(int i=0; i < count; i++)
    {
    	char tmp[10];
        
        memoryListBox->GetString(tmp, i);
 		strContainer += tmp;
		strContainer += "\n";
	}

    copyToClipboard(strContainer);
}




void TMemoryDialog::copyToClipboard(CString & strContainer)
{
    HANDLE StringGlobalHandle;
    LPSTR StringGlobalPtr;

    StringGlobalHandle = GlobalAlloc (GMEM_MOVEABLE,
                           (LONG)lstrlen(strContainer) + 1);

    if (StringGlobalHandle)
    { 
     	StringGlobalPtr = (Pchar)GlobalLock(StringGlobalHandle);

     	if (StringGlobalPtr)
        {
       		lstrcpy(StringGlobalPtr, strContainer);
       		GlobalUnlock(StringGlobalHandle);

       		if (OpenClipboard(HWindow))
            {
        		EmptyClipboard();
        		SetClipboardData(CF_TEXT, StringGlobalHandle);
                
                SetClipboardData(ftwClipboard, StringGlobalHandle);

        		CloseClipboard();
        		return ; 
            } 
       		else
				GlobalFree(StringGlobalHandle);
     	}
     	else
			GlobalFree(StringGlobalHandle);
    }

    return; 
    
}

/*******************************************************************

	Copy memory Items from Clipboard

*******************************************************************/


void TMemoryDialog::pasteFromClipboard(RTMessage)
{
	HANDLE StringGlobalHandle;
    LPSTR StringGlobalPtr;
    
    if (OpenClipboard(HWindow))
    {
    	if (IsClipboardFormatAvailable(ftwClipboard))
        {
       		StringGlobalHandle = GetClipboardData(ftwClipboard);

       		if (StringGlobalHandle)
            {
        		StringGlobalPtr = (LPSTR) GlobalLock(StringGlobalHandle);

        		if (StringGlobalPtr)
                {
                    LPSTR i=StringGlobalPtr;
                    LPSTR f=i;


                    while(1)
                    {
						while(*f && *f != '\n')
											f++;

                        if(!*f)
                        	break;


                    	*f='\0';

                        memoryListBox->InsertString(i, -1);


                        i=++f;
                    }

                    GlobalUnlock(StringGlobalHandle);
 				}
            }
		}
        CloseClipboard();
    }
}

/*******************************************************************

	Enable/Disable menu item of the dialog

*******************************************************************/

void TMemoryDialog::WMInitMenu(RTMessage)
{

    BOOL isMem = memoryListBox->GetCount() > 0 || memoryListBox->GetSelIndex() > 0;
    BOOL isMems = memoryListBox->GetCount() > 0;
    BOOL isClipboard=FALSE;

	if (OpenClipboard(HWindow))
    {
    	if (IsClipboardFormatAvailable(ftwClipboard))
         								isClipboard=TRUE;

        CloseClipboard();
    }

    HMENU hMenu;

	hMenu = GetMenu(HWindow);

    EnableMenuItem(hMenu, CM_EDITMEM,   isMem ? MF_ENABLED : MF_GRAYED);
	EnableMenuItem(hMenu, CM_DELETEMEM, isMem ? MF_ENABLED : MF_GRAYED);


    EnableMenuItem(hMenu, CM_EDITCOPY,  isMem 		? MF_ENABLED : MF_GRAYED);
    EnableMenuItem(hMenu, CM_EDITPASTE, isClipboard ? MF_ENABLED : MF_GRAYED);
    EnableMenuItem(hMenu, CM_EMPTYCLIP, isClipboard ? MF_ENABLED : MF_GRAYED);

    EnableMenuItem(hMenu, CM_COPYALLMEM, 	isMems 	?   MF_ENABLED : MF_GRAYED);
    EnableMenuItem(hMenu, CM_DELETEALLMEM, 	isMems 	?   MF_ENABLED : MF_GRAYED);
}


/*******************************************************************

	Empty Clipboard contents

*******************************************************************/

void TMemoryDialog::emptyClipboard(RTMessage)
{
    if (OpenClipboard(HWindow))
    {
    	EmptyClipboard();
        CloseClipboard();
    }
}


