/*===========================================================================

   FTW Memory Dialog routine

   $ Version 3.1  10/09/93  22:51:55 $

   Copyright 1990, 1993 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not        
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is          
   for no cost.                                                            
                                                                           
===========================================================================*/

#ifndef __MEMDLG_H
#define __MEMDLG_H

#include "buffers.h"
#include "cstring.h"
#include <dialog.h>

_CLASSDEF(TMemoryDialog)
struct TMemoryDialog : public TDialog
{
	TMemoryDialog( PTWindowsObject AParent, LPSTR AName, RTMemoryBuffer buff, unsigned int ftwClip );

private:

	unsigned int 	ftwClipboard;

	PTListBox 		memoryListBox;

    void 			copyToClipboard(CString & strContainer);
    void 			SetupWindow();
	void 			ActivateButton();

	virtual void 	newMem(RTMessage) 				= [CM_FIRST + CM_NEWMEM];
    virtual void 	deleteMem(RTMessage) 			= [CM_FIRST + CM_DELETEMEM];
    virtual void 	editMem(RTMessage) 			= [CM_FIRST + CM_EDITMEM];
    virtual void 	copyAllToClipboard(RTMessage) 	= [CM_FIRST + CM_COPYALLMEM];
    virtual void 	copyMemToClipboard(RTMessage) 	= [CM_FIRST + CM_EDITCOPY];
    virtual void 	pasteFromClipboard(RTMessage) 	= [CM_FIRST + CM_EDITPASTE];
    virtual void 	emptyClipboard(RTMessage) 		= [CM_FIRST + CM_EMPTYCLIP];

	virtual void 	deleteAllMem(RTMessage) 		= [CM_FIRST + CM_DELETEALLMEM];
	virtual void 	Ok(RTMessage) 				 	= [ID_FIRST + IDOK];
	virtual void 	HandleMemListBox(RTMessage) 	= [ID_FIRST + ID_FTMEMORY];
    virtual void 	WMInitMenu(RTMessage)       	= [WM_FIRST + WM_INITMENU];

};

#endif	// !defined __MEMDLG_H