/*===========================================================================

   FTW Memory Object routine

   $ Version 3.1  10/09/92  23:04:23 $ 

   Copyright 1990, 1993 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not        
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is          
   for no cost.                                                            
                                                                           
===========================================================================*/

#include "memory.h"
#include <string.h>

/*******************************************************************

	Memory Object Constructor

*******************************************************************/

Memory::Memory(Pchar frequency, int channel)
{
	theMemory = new char[11];
	setFrequency(frequency);
	setChannel(channel);
}

/*******************************************************************

	Memory Object Destructor

*******************************************************************/

Memory::~Memory()
{
	delete theMemory;
}

/*******************************************************************

	Set the frequency value to Memory Object

*******************************************************************/

void Memory::setFrequency(Pchar frequency)
{
	strcpy(theMemory,frequency);
}

/*******************************************************************

	Set the channel value to Memory Object

*******************************************************************/

void Memory::setChannel(int channel)
{
	theChannel=channel;
}


/*******************************************************************

	Get the frequency value from Memory Object

*******************************************************************/

Pchar Memory::value() const
{
	return theMemory;
}

/*******************************************************************

	Or via operator const Pchar, const

*******************************************************************/

Memory::operator Pchar() const
{
	return theMemory;
}


/*******************************************************************

	Get the channel value from Memory Object

*******************************************************************/

int Memory::channel()
{
	return theChannel;
}

/*******************************************************************

	Set the type (use it if bound checking is ON) to
	Memory Object

*******************************************************************/

char Memory::setType(char type)
{
	return theType=type;
}

/*******************************************************************

	Get the type (use it if bound checking is ON) from
	Memory Object

*******************************************************************/


char Memory::getType() const 
{
	return theType;
}
