/*===========================================================================

   FTW Offset Dialog routine

   $ Version 3.1  10/09/93  23:00:01 $ 

   Copyright 1990, 1993 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not        
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is          
   for no cost.                                                            
                                                                           
===========================================================================*/

#include "offdlg.h"
#include "selstep.h"
#include "ftwid.h"
#include <edit.h>
#include <groupbox.h>
#include <radiobut.h>
/*******************************************************************

	Create an Offset Dialog

*******************************************************************/

TOffsetDialog::TOffsetDialog(PTWindowsObject AParent, LPSTR AName,
						RTChangeOffsetBuffer buffer, int *currentOffset):\
TDialog(AParent, AName, NULL)
{
	selectedOffset=currentOffset;
	new TEdit(this, ID_INPUT_OFFSET, 10);

	TFtwGroupBox *group = new TFtwGroupBox (this, ID_OFFSET_GROUP, &tempOffset);

	new TRadioButton(this,ID_SIMPLEX,group);
	new TRadioButton(this,ID_N_OFFSET,group);
	new TRadioButton(this,ID_P_OFFSET,group);

	TransferBuffer=&buffer;
}

/*******************************************************************

	Respond to an IDOK Message

*******************************************************************/


void TOffsetDialog::Ok(RTMessage Msg)
{
	*selectedOffset=tempOffset;
	TDialog::Ok(Msg);
}


/*******************************************************************

	Setup the dialog contents with the appropriate default

*******************************************************************/


void TOffsetDialog::SetupWindow()
{

/*******************************************************************

	Call the default function

*******************************************************************/

	TWindowsObject::SetupWindow();

/*******************************************************************

	Check the appropriate RadioButton

*******************************************************************/

	CheckRadioButton (HWindow, ID_SIMPLEX, ID_P_OFFSET, *selectedOffset);
}
