/*===========================================================================

   FTW Step Selection DialogBox routine

   $ Version 3.1  10/09/93  22:58:16 $ 

   Copyright 1990, 1993 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is          
   for no cost.                                                            
                                                                           
===========================================================================*/

#include "selstep.h"
#include "ftwid.h"
#include <radiobut.h>

/*******************************************************************

	Create an GroupBox Object storing the current radio button
	checked.

*******************************************************************/

TFtwGroupBox::TFtwGroupBox(PTWindowsObject AParent, int ResourceID,
							int *currentID) :\
TGroupBox(AParent, ResourceID, NULL)
{
	selectedID=currentID;
}

/*******************************************************************

	Respond to any Radio ID modifing the current selected Radio

*******************************************************************/

void TFtwGroupBox::SelectionChanged(int ControlID)
{
	*selectedID=ControlID;
	TGroupBox::SelectionChanged(ControlID);
}

/*******************************************************************

	Create an Dialog step Dialog

*******************************************************************/

TSetStepDialog::TSetStepDialog( PTWindowsObject AParent, LPSTR AName,
							int* currentStep) :\
TDialog( AParent, AName )
{
	selectedID=currentStep;

	// Create a group for the Radio Button

	stepGroup = new TFtwGroupBox(this, ID_STEP_BOX, &tempID);

	new TRadioButton(this, ID_5_KHZ,  stepGroup);
	new TRadioButton(this, ID_10_KHZ,  stepGroup);
	new TRadioButton(this, ID_12_5_KHZ, stepGroup);
	new TRadioButton(this, ID_20_KHZ,  stepGroup);
	new TRadioButton(this, ID_25_KHZ,  stepGroup);
}


/*******************************************************************

	respond to IDOK Message

*******************************************************************/

void TSetStepDialog::Ok(RTMessage Msg)
{

/*******************************************************************

	Set the selected Radio Button ID

*******************************************************************/

	*selectedID=tempID;

/*******************************************************************

	the call the default OK

*******************************************************************/

	TDialog::Ok(Msg);
}

/*******************************************************************

	Setup the dialog with the appropriate defaults

*******************************************************************/

void TSetStepDialog::SetupWindow()
{

/*******************************************************************

	Call the default function

*******************************************************************/

	TWindowsObject::SetupWindow();

/*******************************************************************

	Check the appropriate radioButton

*******************************************************************/

	CheckRadioButton (HWindow, ID_5_KHZ, ID_25_KHZ, *selectedID);
}
