/*===========================================================================

   FTW Setup DialogBox routine

   $ Version 3.1  10/09/93  22:55:59 $ 

   Copyright 1990, 1993 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not        
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is          
   for no cost.

===========================================================================*/

#include "setup.h"
#include <dir.h>	// for MAXPATH
#include <commdlg.h>
#include <stdio.h>

/*******************************************************************

	Define some costant

*******************************************************************/


static Pchar comPort[] = { "COM1", "COM2", "COM3", "COM4", NULL };
static Pchar radioType[] = { "FT-212", "FT-712", NULL };


/*******************************************************************

	Define the ComboBox for COM selection in the preference
	Dialog

*******************************************************************/

class TSetupCombo : public TComboBox
{
	char **			theArray;
	virtual void 	SetupWindow();
public:
	TSetupCombo (PTWindowsObject AParent, int ResourceId, WORD ATextLen, char **TheArray, PTModule AModule = NULL) :
		TComboBox (AParent, ResourceId, ATextLen, AModule)
	{
		theArray=TheArray;
	}
};

/*******************************************************************

	Setup the Combo with the default

*******************************************************************/

void TSetupCombo::SetupWindow()
{
	for (int i=0; i < 4; i++)
		if (theArray[i])
			AddString(theArray[i]);
		else
			break;

	SetText(theArray[0]);
	TComboBox::SetupWindow();
}

/*******************************************************************

	Create and SetupDialog

*******************************************************************/

TSetupDialog::TSetupDialog(PTWindowsObject AParent, LPSTR AName,
							PTConfigParam config, PTModule AModule) :\
TDialog(AParent, AName, AModule)
{
	configuration = config;

	numOfRadioGroup = new TGroupBox (this, ID_NUMRADIO_GROUP);
	oneRadio 		= new TRadioButton(this, ID_ONE_RADIO, numOfRadioGroup);
	twoRadio 		= new TRadioButton(this, ID_TWO_RADIO, numOfRadioGroup);

	option1Group 	= new TGroupBox(this, ID_RADIO1_OPTION);
	radio1Com  		= new TSetupCombo(this, ID_RADIO1_COM,  4, comPort);
	radio1Type 		= new TSetupCombo(this, ID_RADIO1_TYPE, 6, radioType);

	option2Group 	= new TGroupBox(this, ID_RADIO2_OPTION);
	radio2Com  		= new TSetupCombo(this, ID_RADIO2_COM,  4, comPort);
	radio2Type 		= new TSetupCombo(this, ID_RADIO2_TYPE, 6, radioType);

	saveFrq 		= new TCheckBox( this, ID_SAVE_FRQ, NULL );
    memFile 		= new TEdit( this, ID_MEMFILE, MAXPATH);
}

/*******************************************************************

	Setup the Dialog with the default

*******************************************************************/

void TSetupDialog::SetupWindow()
{
	TDialog::SetupWindow();
	ResetValue();
}

/*******************************************************************

	Reset with the defaults value

*******************************************************************/

void TSetupDialog::ResetValue()
{

	int i=configuration->numOfRadio();

	CheckRadioButton (HWindow, ID_ONE_RADIO, ID_TWO_RADIO, ID_ONE_RADIO + i);

	radio1Com->SetText(configuration->getRadio1Com());
	radio1Type->SetText(configuration->getRadio1Type());

	radio2Com->SetText(configuration->getRadio2Com());
	radio2Type->SetText(configuration->getRadio2Type());

	saveFrq->SetCheck((configuration->isSaveFrq()) ? BF_CHECKED : BF_UNCHECKED);

	EnableWindow(GetItemHandle(ID_RADIO2_TYPE), i);
	EnableWindow(GetItemHandle(ID_RADIO2_OPTION), i);
	EnableWindow(GetItemHandle(ID_RADIO2_COM), i);

	memFile->SetText(configuration->getMemoryFilename());
}

/*******************************************************************

	Respond to 1 radio Selection

*******************************************************************/

void TSetupDialog::IDOneRadio(RTMessage)
{
	CheckRadioButton (HWindow, ID_ONE_RADIO, ID_TWO_RADIO, ID_ONE_RADIO);

	EnableWindow(GetItemHandle(ID_RADIO2_TYPE), FALSE);
	EnableWindow(GetItemHandle(ID_RADIO2_OPTION), FALSE);
	EnableWindow(GetItemHandle(ID_RADIO2_COM), FALSE);
}

/*******************************************************************

	Respond to 2 radio Selection

*******************************************************************/

void TSetupDialog::IDTwoRadio(RTMessage)
{
	CheckRadioButton (HWindow, ID_ONE_RADIO, ID_TWO_RADIO, ID_TWO_RADIO);

	EnableWindow(GetItemHandle(ID_RADIO2_TYPE), TRUE);
	EnableWindow(GetItemHandle(ID_RADIO2_OPTION), TRUE);
	EnableWindow(GetItemHandle(ID_RADIO2_COM), TRUE);
}

/*******************************************************************

	Respond to the Reset default message

*******************************************************************/

void TSetupDialog::IDResetDefault(RTMessage)
{
	ResetValue();
}

/*******************************************************************

	Respond to the IDOK message storing the control value in the
	appropriate buffer slots.

*******************************************************************/

void TSetupDialog::Ok(RTMessage Msg)
{
	configuration->setNumOfRadio(BF_UNCHECKED==oneRadio->GetCheck());

	char buff[8];

	radio1Com->GetText(buff,5);
	configuration->setRadio1Com(buff);

	radio1Type->GetText(buff,7);
	configuration->setRadio1Type(buff);

	radio2Com->GetText(buff,5);
	configuration->setRadio2Com(buff);

	radio2Type->GetText(buff,7);
	configuration->setRadio2Type(buff);

	configuration->setSaveFrq(BF_CHECKED==saveFrq->GetCheck());

    char maxPath[MAXPATH];

    memFile->GetText(maxPath,MAXPATH);

	configuration->setMemoryFilename(maxPath);

    TDialog::Ok(Msg);
}

void TSetupDialog::IDBrowse (RTMessage)
{
	OPENFILENAME ofnTemp;
	char szTemp[] = "Mem Files (*.MEM)\0*.MEM\0";
    char szName[256];

/*
Note the initialization method of the above string.  The GetOpenFileName()
function expects to find a string in the OPENFILENAME structure that has
a '\0' terminator between strings and an extra '\0' that terminates the
entire filter data set.  Using the technique shown below will fail because
"X" is really 'X' '\0' '\0' '\0' in memory.  When the GetOpenFileName()
function scans szTemp it will stop after finding the extra trailing '\0'
characters.

	char szTemp[][4] = { "X", "*.*", "ABC", "*.*", "" };

The string should be "X\0*.*\0ABC\0*.*\0".

Remember that in C or C++ a quoted string is automatically terminated with
a '\0' character so   char "X\0";   would result in 'X' '\0' '\0' which
provides the extra '\0' that GetOpenFileName() needs to see in order to
terminate the scan of the string.  Just 'char ch "X";' would result in 'X'
'\0' and GetOpenFileName() would wander off in memory until it lucked into
a '\0' '\0' character sequence.
*/

/*
Some Windows structures require the size of themselves in an effort to
provide backward compatibility with future versions of Windows.  If the
lStructSize member is not set the call to GetOpenFileName() will fail.
*/
    memset(&ofnTemp, 0, sizeof(OPENFILENAME) );

	ofnTemp.lStructSize = sizeof( OPENFILENAME );
	ofnTemp.hwndOwner = HWindow;			// An invalid hWnd causes non-modality
	ofnTemp.hInstance = 0;
	ofnTemp.lpstrFilter = (LPSTR)szTemp;	// See previous note concerning string
	ofnTemp.lpstrCustomFilter = NULL;
	ofnTemp.nMaxCustFilter = 0;
	ofnTemp.nFilterIndex = 1;
	ofnTemp.lpstrFile = (LPSTR)szName;		// Stores the result in this variable
	ofnTemp.nMaxFile = sizeof( szName );
	ofnTemp.lpstrFileTitle = NULL;
	ofnTemp.nMaxFileTitle = 0;
	ofnTemp.lpstrInitialDir = NULL;
	// ofnTemp.lpstrTitle = "Prova";				// Title for dialog
	ofnTemp.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_PATHMUSTEXIST;
	ofnTemp.nFileOffset = 0;
	ofnTemp.nFileExtension = 0;
	ofnTemp.lpstrDefExt = "*";
	ofnTemp.lCustData = NULL;
	ofnTemp.lpfnHook = NULL;
	ofnTemp.lpTemplateName = NULL;
/*
If the call to GetOpenFileName() fails you can call CommDlgExtendedError()
to retrieve the type of error that occured.
*/
	if(GetOpenFileName( &ofnTemp ) != TRUE)
	{
		DWORD Errval;	// Error value
		char Errstr[50]="GetOpenFileName returned Error #";
		char buf[5];	// Error buffer

		Errval=CommDlgExtendedError();
		if(Errval!=0)   // 0 value means user selected Cancel
		{
			sprintf(buf,"%ld",Errval);
			strcat(Errstr,buf);
			MessageBox(HWindow,Errstr,"WARNING",MB_OK|MB_ICONSTOP);
		}
	}
    else
		memFile->SetText(szName);

	InvalidateRect( HWindow, NULL, TRUE );	// Repaint to display the new name
}
