/*===========================================================================

   FTW Setup Dialog header

   $ Version 3.1  10/09/93  22:45:31 $ 

   Copyright 1990, 1992 by Marco Savegnago.  All rights reserved.        
   This software may be freely distributed and used, but it may not        
   under any circumstances be sold by anyone other than the author.        
   It may be distributed by a commercial company as long as it is          
   for no cost.                                                            
                                                                           
===========================================================================*/

#ifndef __SETUP_H
#define __SETUP_H

#include "config.h"
#include "ftwid.h"
#include <checkbox.h>
#include <combobox.h>
#include <dialog.h>
#include <groupbox.h>
#include <radiobut.h>
#include <edit.h>


_CLASSDEF(TSetupDialog)
class TSetupDialog : public TDialog
{
public:
	TSetupDialog(PTWindowsObject AParent, LPSTR AName, PTConfigParam config, PTModule AModule = NULL);

private:
	PTGroupBox 		numOfRadioGroup;
	PTRadioButton 	oneRadio;
	PTRadioButton 	twoRadio;

	PTGroupBox 		option1Group;
	PTComboBox 		radio1Com;
	PTComboBox 		radio1Type;

	PTGroupBox 		option2Group;
	PTComboBox 		radio2Com;
	PTComboBox 		radio2Type;

	PTCheckBox 		saveFrq;

	PTConfigParam 	configuration;

    PTEdit  		memFile;

	virtual void 	IDOneRadio(RTMessage) 		= [ID_FIRST + ID_ONE_RADIO];
	virtual void 	IDTwoRadio(RTMessage) 		= [ID_FIRST + ID_TWO_RADIO];
	virtual void 	IDResetDefault(RTMessage) 	= [ID_FIRST + ID_RESET_DEFAULT ];
	virtual void 	Ok(RTMessage) 				= [ID_FIRST + IDOK ];
    virtual void 	IDBrowse (RTMessage) 		= [ID_FIRST + ID_BROWSEMEM];

    virtual void 	SetupWindow();
	void 	     	ResetValue();
};

#endif 	//!defined  SETUP_HPP