/*
    SETQRG.CPP

    Versione 2.0 del 11/6/1993 - Marco Savegnago IW3FQG

    Questo programma permette di impostare la frequenza di ricetrasmettitore
    amatoriale del tipo (generico) YAESU FT-X12 direttamente da dos.
    L'output avviene sulla porta seriale selezionata da command line
    sul PIN TD (classico) oppure modulando il segnale su DTR o RTS.
    Quest'ultima soluzione permette di non dedicare una porta seriale
    ai ricetrasmettitori e sfruttare al massimo le eventuali seriali
    collegate a TNC che non fanno uso di queste linee (vedi TNC WA8DED).

    Il programma e' scritto in C++ e utilizza il metodo proposto da
    Bruce Eckel in C++ Report Marzo/Aprile 1992 per realizzare classi
    con costruttori virtuali.
    In questo programma la selezione dell'output fatta mediante command line
    lega runtime l'istanza thePort con il tipo opportuno di porta...
    Lo so' si poteva fare anche in maniera piu' semplice ma forse il
    risultato non sarebbe stato lo stesso...

    Il sistema utilizzato per realizzare la trasmissione sulla TEmulPort
    potrebbe essere utilizzato anche per la porta parallela, ma a questo
    pensero' in futuro.

    Fate attenzione costruendo il circuito di adattamento!!!
    Alcuni colleghi mi hanno telefonato disperati perche' lo smoke test aveva
    dato esito positivo!

    Il circuito non e' il massimo in quanto a autoprotezione ma...
    basta solo un po' attenzione!

    A proposito ... per ricompilare usate Borland C++ con la seguente
    sintassi:

    bcc -O2 setqrg


    Note sul funzionamento:

    Personalmente ho utilizzato il programma sui due RTX FT-212 (144) e
    712 (430) ma credo non ci siano problemi di compatibilita' con l'FT-912.


    Sintassi:

    SETQRG [opzioni] <comport> <frq>

    comport:

      0 = segue indirizzo della porta HEX es: 03F8

      1 = COM1  (03f8)
      2 = COM2  (02f8)
      3 = COM3  (03e8)
      4 = COM4  (02e8)


    L'argomento frq deve contenere le cifre significative della frequenza da
    impostare nel ricetrasmettitore.

    Es:

        per 145.000  Mhz basta 145
	 "  144.750  Mhz  ""   14475
	 "  144.7125 Mhz  ""   1447125
     "  433.625  Mhz  ""   433625


    opzioni:

        R<n>   Specifica la radio di destinazione (default R1)
        O<S|A> Specifica il modo di output S)tandard o A)lternativo (default S)


    Attenzione che il programma non esegue alcun controllo sull'esattezza
    della frequenza in quanto l'uso e' tipico in file batch o in script di
    controllo del forwarding e poi anche se si sbaglia il ricetrasmettitore
    ignora il comando.


	PC <-> FT-x12 CAT interface on Standard Serial Output

	1990 Marco Savegnago IW3FQG




						Schematics for 1 radio on 1 serial port

                                        /-----\
                                 o------I  R  I---------> 2 +5v
                                 I      \-----/
                                 I
                                 I      + I/ I -
                                 o--------I DI ---------> 1 UP
                                 I        I\ I
                                 I
                             C   I      + I/ I -
                        I  / ----o--------I DI ---------> 3 DOWN
             /-----\  B I /   T           I\ I
 TD  2   <---I  R  I----I\
             \-----/    I  \   E
                             \
 GND 7   <-------------------I--------------------------> 7 GND



				Schematics for 2 radio on 1 serial port (shared)


                                                        /-----\
                                                    |---I  R  I----> 2 +5v
                                                    |   \-----/
                                                    |
                                 T    C             | + I/ I -
                 /-----\           I /------o------ o---I DI ------> 1 UP
RTS 4 <----------I  R  I-----------I\       | -     |   I\ I
                 \-----/         B I \ E   ---      |
                                     |     \D/      | + I/ I -
                                     |     ---      |---I DI ------> 3 DOWN
                            T    C   |      | +         I\ I
             /-----\          I /--- |------o                    (RADIO 1)
TD 2  <------I  R  I----------I\     |      | +        /-----\
             \-----/        B I \ E  |     ---     |---I  R  I-----> 2 +5v
                                 |   |     /D\     |   \-----/
                                 |   |     ---     |
                        T   C    |   |      | -    | + I/ I -
         /-----\          I /----|---|------o------o---I DI -------> 1 UP
DTR 20 <-I  R  I----------I\     |   |             |   I\ I
         \-----/        B I \ E  |   |             |
                             |   |   |             | + I/ I -
                             |   |   |             |---I DI -------> 3 DOWN
                             |   |   |                 I\ I
                             |   |   |                          (RADIO 2)
                             |   |   |
GND 7 <----------------------o---o---o-----------------------------> 7 GND

																(on both RADIO)




	PC <-> FT-x12 CAT interface su Alternate Serial Output

	1993 Marco Savegnago IW3FQG




                Schematics for 1 radio on 1 serial port

                                               /-----\
                                        o------I  R  I---------> 2 +5v
                                        I      \-----/
                                        I
                                        I      + I/ I -
                                        o--------I DI ---------> 1 UP
                                        I        I\ I
                                        I
                                    C   I      + I/ I -
                               I  / ----o--------I DI ---------> 3 DOWN
                    /-----\  B I /   T           I\ I
DTR 20 / RTS 4  <---I  R  I----I\
(Out 1 / Out 2)     \-----/    I  \   E
                                    \
        GND 7   <-------------------I--------------------------> 7 GND



				Schematics for 2 radio on 1 serial port (shared)


                                                        /-----\
                                                    |---I  R  I----> 2 +5v
                                                    |   \-----/
                                                    |
                                T    C              | + I/ I -
                 /-----\           I /------------- o---I DI ------> 1 UP
DTR 20<----------I  R  I-----------I\               |   I\ I
                 \-----/         B I \ E            |
                                     |              | + I/ I -
                                     |              |---I DI ------> 3 DOWN
                                     |                  I\ I
                                     |                          (RADIO 1)
                                     |                 /-----\
                                     |             |---I  R  I-----> 2 +5v
                                     |             |   \-----/
                                     |             |
                        T   C        |             | + I/ I -
         /-----\          I /--------|-------------o---I DI -------> 1 UP
RTS 4  <-I  R  I----------I\         |             |   I\ I
         \-----/        B I \ E      |             |
                             |       |             | + I/ I -
                             |       |             |---I DI -------> 3 DOWN
                             |       |                 I\ I
                             |       |                          (RADIO 2)
                             |       |
GND 7 <----------------------o-------o-----------------------------> 7 GND

																(on both RADIO)

		T = Common NPN Transistors (ex: BC238)
		R = 1 or 2 K (not critical)
		D = 1N4148.



 E infine ... Di chi e' questo?
 :
 E' mio!

   Marco Savegnago IW3FQG
   Str.lla Ospedale 87
   36100 Vicenza
   Packet  : IW3FQG @ IW3EXH.ITA.EU
   Internet: mc2365@mclink.it

*/

#include <stdio.h>
#include <dos.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define LCR comBase + 3
#define MCR comBase + 4
#define LSR comBase + 5
#define MSR comBase + 6
#define TIMER1  040H        /* base I/O Port for timer */
#define TIMER2  TIMER1+3    /* port to latch count */

enum { False, True };
enum portType { standard, emul };
enum destType { one, two };

typedef unsigned int word;

/* Globals */

const char thisVersion[] = "2.0";

int     _htoi (char *p);
void    uso();
char*   frqString2YaesuCmdString(char *yaesu, char *frq);

class TPort
{
        TPort* p;

protected:

        word comBase;
        char oldLCR;
        char oldMCR;
        int  oldBaud;
        char destRadio;

public:

        TPort(word portBase, portType type = standard, destType dest = one);

        virtual ~TPort() { delete p; }

        void    changeFrq(char* destFrq);
        void    catOn();
        void    catOff();


        virtual int  openCom() { return p->openCom(); };
        virtual void sendCom( char* string, int len) { p->sendCom(string, len);}
        virtual void closeCom() { p->closeCom(); }

protected:

        TPort() { p = 0; }
};

void TPort::changeFrq(char* destFrq)
{
        char frequenza[]="00000000";

        char *s=destFrq;
        char *d=frequenza;

        while(*s)
                *d++=*s++;

        char cmd[6];

        frqString2YaesuCmdString(cmd, frequenza);

        catOn();
        sendCom(cmd, 5);
        catOff();
}

/*
**  Attiva CAT
*/

void TPort::catOn()
{
        sendCom("\0\0\0\0\0",5);
}

/*
**  Disattiva CAT
*/

void TPort::catOff()
{
        sendCom("\0\0\0\0\x80",5);
}


class TStdPort : public TPort
{
public:
        TStdPort (word base, char dest) { comBase=base; destRadio=dest; }

        int  openCom();
        void sendCom(char*, int);
        void closeCom();
};

int TStdPort::openCom()
{

/*
**    Setta DLAB nell'LCR a 1 per poter settare la velocita'
*/

        oldLCR = inportb(LCR);
        outportb ( LCR, 0x80 );

/*
**    Legge la vecchia velocita', la memorizza in Old_Baud e setta la velocita'
**    della seriale a 4800 baud
*/

        oldBaud = inport (comBase);
        outport (comBase, 0x0018);

/*
**    Setta DLAB in LCR a 0 e predispone la porta a funzionare con la
**    configurazione 8N2.
*/

        outportb ( LCR , 0x07 );

        oldMCR = inportb(MCR);
        outportb(MCR,0);

        return True;
}

void TStdPort::closeCom ()
{
        outportb (LCR,0x80);
        outport  (comBase, oldBaud);
        outportb (LCR,oldLCR);
        outportb (MCR,oldMCR);
        outportb (LSR,0);
        outportb (MSR,0);
}

void TStdPort::sendCom(char *s, int num)
{
        if(destRadio)
                outportb ( MCR, destRadio + 1);

        while (num--)
        {
                outportb(comBase , *s++);
                while (!(inportb (LSR) & 0x20))
                ;
                delay(10);
        }
}

class TEmulPort : public TPort
{
        static unsigned int BITTIME;

        word getTime();
        word sendBit(word until, word sigType);
        void sendByte(unsigned char c);

public:
        enum sigType { STOP, START };

        TEmulPort(word base, char dest) { comBase=base; destRadio=dest; }

        int  openCom();
        void sendCom(char*, int);
        void closeCom();
};

unsigned int TEmulPort::BITTIME=500;

#pragma inline

word TEmulPort::getTime()
{
	asm     MOV AL,0        /* latch count          */
	asm     OUT TIMER2,AL

	asm     IN  AL,TIMER1   /* read LSB             */
	asm     XCHG    AL,AH   /* save                 */
	asm     IN  AL,TIMER1   /* read MSB             */
	asm     XCHG    AL,AH   /* make order correct   */

	return (_AX);
}

word TEmulPort::sendBit(word until, word sigType)
{
        word com=comBase;
        char dest=destRadio;

/*
   Chi sa' come si fa' a usare una variabile membro di una classe in BASM??
   In questo caso la linea che segue in teoria potrebbe venir scritta:

   asm  MOV     DX, this.comBase

   Ma apparentemente non funziona.
*/

asm     MOV     DX,com
asm     IN      AL,DX           /* legge il valore della porta */
asm     MOV     AH,dest         /* il valore del bitmask */

asm     MOV 	CX, sigType

asm     JCXZ 	stop

asm     OR      AL,AH           /* per forzare a 1 il bit che interessa */

asm     JMP     outbit

stop:

asm     NOT     AH              /* lo nega */
asm     AND     AL,AH

outbit:

asm     OUT     DX,AL

asm     MOV     BX,until

loop:
asm     MOV 	AL,0        	/* latch count          */
asm     OUT 	TIMER2,AL

asm     IN  	AL,TIMER1
asm     XCHG    AL,AH
asm     IN  	AL,TIMER1
asm     XCHG	AL,AH


asm     SUB     AX,BX
asm     JNS     loop

asm     MOV 	AL,0
asm     OUT 	TIMER2,AL

asm     IN  	AL,TIMER1
asm     XCHG    AL,AH
asm     IN  	AL,TIMER1
asm     XCHG    AL,AH

	return (_AX);
}

void TEmulPort::sendByte(unsigned char c)
{
	register int databit = 8;		/* lunghezza della word */
	register int stopbit = 2;		/* numero di bit di stop */

	/* Prende il tempo ... col cronometro */

	word from = getTime();

	/* Manda il bit di START */

	sendBit ( from -= BITTIME, START );

	/* Trasmette la word */

	while(databit)
	{
		if (c & 1)
			sendBit ( from -= BITTIME, STOP );

		else
			sendBit ( from -= BITTIME, START );

		c >>= 1;

		databit--;
	}

	/* Manda il bit di STOP */

	sendBit ( from -= BITTIME * stopbit, STOP );
}


int TEmulPort::openCom()
{
        /* Salva lo stato di MCR */

        oldMCR = inportb(MCR);
        outportb(MCR,0);

        return True;
}

void TEmulPort::closeCom ()
{
        outportb (MCR,oldMCR);
}

void TEmulPort::sendCom(char *s, int num)
{
	disable();      /* kill interrupts */

	while(num--)
	{
    	sendByte(*s++);
        delay(10);
    }

    enable();
}

TPort::TPort(word portBase, portType type, destType dest )
{

        if(type > emul)
                type = standard;

        switch(type)
        {

                case standard:
                        p = new TStdPort(portBase, dest);
                        break;

                case emul:
                        p = new TEmulPort(portBase + 4, dest + 1);
                        break;

        }
}

/*
**  'Trasforma' la frequenza da stringa a bcd
*/

char* frqString2YaesuCmdString(char *yaesu, char *frq)
{
        int a,b;

         char* s=frq;
        char* d=yaesu;

        while(*s)
        {
                a=*s++ - '0'; b=*s++ - '0';
                *d++=( a * 16 ) + b ;
        }
		*d++=1;
        *d=NULL;

        return (yaesu);
}

/*
**  HexString to int without use assembly ...
*/

int _htoi (char *p)
{
        register int i;
        int ret=0,mult=1;
        char ch;

        i=strlen(p);

        while(i--)
        {
            ch = toupper(*(p+i));

            if(isalpha(ch))
                    ch -= ('A' - 10);
            else
                    ch -= '0';

            ret += ch * mult;
            mult *= 16;
        }

        return (ret);
}

/*
**   Breve help che viene mostrato quando il programma e' lanciato senza
**   argomenti sulla linea di comando
*/

void uso(void)
{
     puts(  "\n"
            "USO: SETQRG [/opzioni] <comport> <frq>\n\n"
            "   comport = 1,2,3,4 (std comport) 0 specifica indirizzo es: 03F8\n"
            "   frq = cifre significative della frequenza da impostare\n\n"
            "    es: 145.000  Mhz = 145\n"
            "        144.750  Mhz = 14475\n"
            "        144.7125 Mhz = 1447125\n\n"
            "   opzioni:\n\n"
            "     R<n>   Specifica la radio di destinazione (default R1)\n"
            "     O<S|A> Specifica il modo di output S)tandard o A)lternativo (default S)\n\n"
            " Es: SETQRG /R2 1 14475 Imposta la frq 144.750 Mhz su Radio 1 Std Mode\n"
        );
}

int main(int na, char **a)
{
	const int std_combase[] = { 0x3f8, 0x2f8, 0x3e8, 0x2e8 };

    word comBase=0;
    char *destFrq=NULL;

    destType destRadio=one;
    portType outType=standard;

    printf("SETQRG %s - %s IW3FQG\n", thisVersion, __DATE__);

/*
**   Controlla che il numero degli argomenti nella linea di comando siano
**   3 altrimenti stampa le istruzioni.
*/
    if (na < 3)
    {
    	uso();
        return False;
    }

    for(int i=1;i<na;i++)
    {
    	char *p=a[i];
        if(*p=='-'||*p=='/')
        {
        	p++;
            switch(toupper(*p))
            {
            	case 'H':
                case '?':
                	uso();
                        return False;

                case 'R':
                	if(*(++p) == '1')
                    	destRadio=one;
                    else
                    	destRadio=two;
                    break;

                case 'O':
                	if(toupper(*(++p)) == 'S')
                    	outType=standard;
                    else
						outType=emul;
                    break;

                default:
                	printf("Opzione non valida %s\n",a[i]);
                    return True;

			}
		}
        else if(!comBase)
        {
			if(*p < '0' && *p > '3')
    		{
    			printf("\n\a?? Porta seriale non valida -> %s\n",p);
				uso();
        		return False;
    		}
            else
            {
    			if(*p=='0')
    				comBase=_htoi (p);
    			else
    				comBase=std_combase[(*p - '1')];
           }
        }
        else
        	destFrq=p;

	}

    if(!comBase || ! destFrq)
    {
    	puts("Errore nei parametri\a");
        uso();

        return True;
    }

    TPort thePort(comBase, outType, destRadio);

	thePort.openCom();
	thePort.changeFrq(destFrq);
	thePort.closeCom();

	return True;
}

