//  GetPass 3.1 - C_FILTER for F6FBB BBS Software

//  Written by Marco Savegnago IW3FQG

#include "gpmsg.h"
#include <stdio.h>
#include <fstream.h>

// Message methode

// Standard constructor

TString::TString( const char * msg )
{
	lenOfString = strlen( msg );
	theString = new char[ lenOfString + 1 ];
	strcpy( theString , msg );
}

TString::~TString()
{
	delete [] theString;
    lenOfString = 0;
}

char *TString::setString(const char * str)
{
	register char * temp;

	lenOfString = strlen( str );
	temp = new char[ lenOfString + 1 ];
	strcpy( temp, str );
	delete theString;
	theString = temp;

	return theString;
}

char * TString::add( const char *str)
{
	register char * temp;

	lenOfString += strlen( str );
	temp = new char[ lenOfString + 1 ];
	strcpy( temp, theString );
	strcat( temp, str );
	delete theString;
	theString = temp;

	return theString;
}

char *TString::isStringInc(char *str)
{
	int len=strlen(str);

	for(char *p=theString;*p;p++)
		if(!strnicmp(str,p,len))
						return(p);

	return(NULL);
}

PasswordString::PasswordString (char *pwd)
:
	TString (pwd)
{
	strip_crlf ( theString );
	thePassword = new char[ lenOfString + 1 ];
	setPasswordLenght();
}

char *PasswordString::setPasswordString(const char * str)
{
	setString(str);
	strip_crlf ( theString );
	lenOfString = strlen( str );
	char* temp = new char[ strlen( str ) + 1 ];
	strcpy( temp, str );
	delete thePassword;
	thePassword = temp;
	setPasswordLenght();

	return thePassword;
}

void PasswordString::setPasswordLenght()
{
	char *p=theString;
	lenOfPasswordString=0;

	while (*p)
	{
		switch (*p)
		{
			case '(':
				while ( *p++ != ')' )
				;
				lenOfPasswordString++;
				break;
			case '"':
				p+=2;
				lenOfPasswordString++;
				break;
			default:
				p++;
				lenOfPasswordString++;
				break;

		}
	}
}

char * PasswordString::getPos ( int pos )
{
	strcpy( thePassword, theString );

	register int i=0;

	char *p=thePassword;

	while (i < pos && *p)
	{
		switch (*p)
		{
			case '(':
				while ( *p++ != ')' )
				;
				i++;
				break;
			case '"':
				p++;
			default:
				p++;
				i++;
				break;
		}
	}

	char *t=p;

	switch (*t)
	{
		case '(':
			while ( *t++ != ')' )
			;
			break;
		case '"':
			t++;
		default:
			t++;
			break;
	}

	*t=EOS;


	return (p);
}

// MessageVect methode

MessageVect::MessageVect( int item )
{
	lenOfMessageVect = item;
	theMessageVect = new Message *[ item ];
	for ( register int i = 0; i < item; i++ )
			theMessageVect[ i ] = NULL;
}


MessageVect::~MessageVect()
{
	for( register int i = 0; i < lenOfMessageVect; i++ )
				if( theMessageVect[ i ] != NULL )
					delete( theMessageVect[ i ] );
	delete [] theMessageVect;
}

int MessageFile::readFile()
{
    int nummessage = 0;
    char temp[ MAXLINELEN ];

    ifstream msg_file ( fname );

    if ( ! msg_file.good() )
    {
#ifdef __DEBUG__
		cout << "DEBUG: I/O Error opening file " << fname << endl;
#endif
		return( 1 );
    }

    while ( msg_file.getline ( temp, sizeof (temp) ) , ! msg_file.eof() )
    {
	    register char * p = temp;

		if(isComment(p))
					continue;

		skipSpace(p);

		if(isComment(p))
					continue;

		if ( ':' == * p)     // found!
		{
			while( ! isdigit( * p ) )
									p++;

			int messagenum;

			if( ( messagenum = atoi( p ) ) > lenOfMessageVect - 1 )
															    break;

	        nummessage++;

			Boolean endmsg = False;

	        Message * message = new Message( messagenum );

	        do
	        {
		        if ( msg_file.getline ( temp, sizeof temp ), msg_file.fail() )
																	        break;

		        p = temp;

		        if( strlen( p ) <= 2 )
		        {
			        switch( * p )
			        {
				        case '!':
						case ';':
					        continue;
				        case '/':
					        if ( *(p+1) == '/')
							        continue;
				        case '%':
					        if ( *( p + 1 ) == '%' )   // skip escape
							        *message + temp;
					        *message + "\n" ;
					        break;

						case '\0':
							endmsg = True;
							break;

						default:
							*message + temp + "\n";
							break;
					}
				}
				else
					*message + temp + "\n";
			}
	        while( endmsg == False );

	        add( message );
	    }
    }
    msg_file.close();	// dummy because the destructor is automatically
						// called when msg_file exit form its scope

    // return ( nummessage != lenOfMessageVect );

    return 0;
}

// ConfigFile methode

Boolean ConfigFile::getBoolParam( int slot )
{
	switch( toupper( * getMessage( slot ) ) )
	{
		case 'Y':
		case 'S':
		case '1':
        case NULL:	// Default True;
			return True;
		default:
			return False;
	}
}

// Strip final \n from string.

char * strip_crlf( char *p )
{
	for( register int i = strlen ( p ) - 1; isspace ( *( p + i ) ) && i >= 0; i-- )
	;

	*( p + i + 1 ) = EOS;

	return p;
}

char * changeSpaceToUnderScore( char *p )
{
	register char *t=p;

	while (*t)
	{
		if (*t == ' ')
			*t = '_';
		t++;
	}

	return p;
}

/* 	Return True if the string contain a wildcard 	*/

Boolean isWildCardIncluded(const char* s)
{
	return Boolean ( strpbrk ( s, "*@#+?<>$\"()") );
}

/*
	This function compare a string with a pattern

	The pattern can contain this wildcard:

		*	0 or more characters
		@	A..Z a..z
		#	0..9
		+	A..Z a..z 0..9 ( @ AND # )
		?	A..F a..f 0..9
		<	a..z
		>	A..Z
		$	@#+?<>
		"	Escape
		()	group
*/

Boolean stringMatch( char *string, const char *pattern, Boolean caseSensitive, Boolean usePattern)
{
	register char *f;
	register const char *p;

	Boolean match = True, skip = False;

	if (*pattern == '*' )
		return ( True );

	if ( usePattern && isWildCardIncluded( pattern ) )
	{

		p = pattern;
		f = string;

		while( *f && *p && ! skip )
		{
			switch ( *p )
			{
				case '*':
					skip = True;
					break;
				case '@':
					if( ! isalpha( *f ) )
					{
						match = False;
						skip = True;
					}
					break;
				case '#':
					if( ! isdigit ( *f ) )
					{
						match = False;
						skip = True;
					}
					break;
				case '+':
					if( ! isalnum ( *f ) )
					{
						match = False;
						skip = True;
					}
					break;
				case '?':
								if( ! isxdigit( *f ) )
					{
						match = False;
						skip = True;
					}
					break;
				case '<':
					if( ! islower( *f ) )
					{
						match = False;
						skip = True;
					}
					break;
				case '>':
					if( ! isupper( *f) )
					{
						match = False;
						skip = True;
					}
					break;

				case '(':
				{

					Boolean lmatch=False;

					while (*++p != ')' )
					{
						if( toupper( *f ) == toupper( *p ) )
									lmatch = True;
					}

					if (!lmatch)
					{
						match=False;
						skip=True;
					}

					break;
				}
				case '$':
					break;

				case '"':
					p++;
				default:
					if( toupper ( *f ) != toupper( *p ) )
					{
						match = False;
						skip = True;
					}
					break;

			}
			p++; f++;
		}
	}
	else
	{
        if(caseSensitive)
    	{
 			if ( strcmp  ( string, pattern) )
								match = False;
		}
        else
		{
			if ( stricmp ( string, pattern) )
								match = False;
        }
	}

	return ( match );
}

void skipSpace(char*& s)
{
	while ( isspace ( *s ) && *s++ )
	;
}

Boolean isComment(char *s)
{
	return Boolean ( *s == '!' || *s == ';' || *s == '\n' ||\
								(*s == '/' && *(s+1) == '/' ) );
}