//  GetPass 3.0 - C_FILTER for F6FBB BBS Software

//  Written by Marco Savegnago IW3FQG

#ifndef __GPMSG_H
#define __GPMSG_H

#include "tdef.h"

#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#define MAXLINELEN 256

class TString
{

protected:

	char *	theString;
	int  	lenOfString;

public:

	TString ( const char * msg = "");

	virtual ~TString();

	char *setString(const char * str);

	char * add( const char *str);

	TString & operator +( const char * msg);

	int compare (char *str);

	char *isStringInc(char *str);

	int len();

	char *getString();

	friend char *strip_crlf (char *p);
};

inline TString::len()
{
	return lenOfString;
}

inline char *TString::getString()
{
	return theString;
}

inline int TString::compare (char *str)
{
	return ( 0 == strcmp ( theString, str ) );
}

inline TString & TString::operator +( const char * msg )
{
	add(msg);
	return *this;
}

class Message : public TString
{
	int  	messageNum;

public:
	Message();

	Message ( int num, const char * msg = "");

	char * getMessage( Boolean strip_crlf = False );

	int getNum();
};

inline Message::Message()
{
	lenOfString = 0;
	theString = NULL;
	messageNum = 0;
}


inline Message::Message( int num, const char * msg ) : TString ( msg )
{
	messageNum = num;
}

inline char * Message::getMessage( Boolean strip )
{
	return ( strip ) ? strip_crlf ( theString ) : theString;
}

inline int Message::getNum()
{
	return messageNum;
}

class PasswordString : public TString
{
	char *thePassword;
	int  lenOfPasswordString;

	void setPasswordLenght();

public:
	PasswordString ( char * pwd = "");

	~PasswordString ();

	char * getPos ( int pos );

	char *setPasswordString(const char * str);

	int lenOfPassword();

	int isWildPassword();

};

inline PasswordString::~PasswordString()
{
	delete thePassword;
}

inline int PasswordString::lenOfPassword()
{
	return lenOfPasswordString;
}

inline int PasswordString::isWildPassword()
{
	return ( * ( theString + strlen (theString) - 1 ) == '*' );
}

class MessageVect
{

protected:

	Message** theMessageVect;
	int  lenOfMessageVect;

public:

	MessageVect( int item );

	virtual ~MessageVect();

    char * getMessage( int slot , Boolean strip_crlf = False );

	char * operator [] ( int slot );

	void add( Message * & message );

};

inline void MessageVect::add( Message * & message )
{
	theMessageVect[ message -> getNum() ] = message;
}

inline char * MessageVect::getMessage( int slot, Boolean strip_crlf )
{
	return( ( char * ) ( theMessageVect[ slot ] ) -> getMessage( strip_crlf ) );
}


inline char * MessageVect::operator [] ( int slot )
{
	return( (char * ) ( theMessageVect[ slot ] ) -> getMessage( True ) );
}


class MessageFile : public MessageVect
{

protected:

	char *	fname;

public:

	MessageFile( char *filename, int numslot );

	int readFile();
};

inline MessageFile::MessageFile( char * filename, int numslot ) : MessageVect( numslot )
{
	fname = filename;
}

struct ConfigFile : public MessageFile
{
	ConfigFile( char *filename, int numslot);

	char *getStrParam( int slot );

	Boolean getBoolParam( int slot );

	int getValueParam( int slot );
};

inline ConfigFile::ConfigFile( char * filename, int numslot )\
:
	MessageFile( filename, numslot )
	{
	}

inline char * ConfigFile::getStrParam( int slot )
{
	return getMessage( slot, True );
}

inline int ConfigFile::getValueParam( int slot )
{
	return ( atoi( getMessage( slot ) ) );
}

extern 	char * strip_crlf ( char * p);
extern  char * changeSpaceToUnderScore( char *p );
extern  Boolean stringMatch( char *string, const char *pattern, Boolean caseSensitive=False, Boolean usePattern=True);
extern 	void skipSpace(char*& s);
extern 	Boolean isComment(char *s);
extern 	Boolean isWildCardIncluded(const char* s);

#endif //__GPMSG_H

