//  GetPass 2.9 - C_FILTER for F6FBB BBS Software

//  Written by Marco Savegnago IW3FQG

#include "gpmsg.h"
#include "gppass.h"
#include "gpmd2.h"
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fstream.h>
#include <dos.h>

Password::Password( char *call, char *fpassword, char option, int ndigit )
{
	callsign = call;

	_callsign = new char [ strlen ( call ) + 1 ];

    strcpy( _callsign , callsign );

    char *p;

	if (NULL!=(p=strchr (_callsign,'-')))
	{
		*p++=NULL;
		strcat(_callsign,p);
	}

	passwordFile = fpassword;
	passwordOption = option;
	numOfDigit = ndigit;
	passwordString = NULL;
	digit = NULL;
	prevPassword = new TString;
	nextPassword = new TString;
	lastPasswordOk = 'N';
	MD2RandomGenerator = new TString;

	fnsplit( fpassword, curr_drive, curr_dir, NULL, NULL );

}

Password::~Password()
{
	delete _callsign;
	delete passwordString;
	delete digit;
	delete nextPassword;
	delete prevPassword;
	delete MD2RandomGenerator;
}

int Password::readPassword()
{
	// return:
	//  		0 password OK
	// 	   		1 password not found
	// 	   		2 I/O error
    //     		3 User don't need the password
    //     		4 User must be disconected
    //     		5 User not support MD2
    //     		6 User not support Matrix

	int ret = 1;

	ifstream pwd_file( passwordFile);

	if ( ! pwd_file.good() )
	{
#ifdef __DEBUG__
		cout << "DEBUG: I/O error opening file " << passwordFile << endl;
#endif
		return( 2 );
	}

	char temp[ LENLINE ];

	char label[ 20 ];

	while ( pwd_file.getline( temp, sizeof ( temp ) ), ! pwd_file.eof() )
	{
		char *s = temp;
		char *d = label;

		if(isComment(s))
					continue;

		skipSpace(s);

		if(isComment(s))
					continue;

		while ( !isspace(*s) )
					*d++ = *s++;

		*d = EOS;

		if( stringMatch( callsign, label) )
		{
			skipSpace(s);

			passwordString = new PasswordString(s);

			if( passwordString->compare("__NOPWD__") )
												return 3;
			else
				if( passwordString->compare("__DISC__") )
													return 4;
			else
				if( NULL != (s=passwordString->isStringInc("__NOMD2__" )))
				{
					   s += 9;  // len of __NOMD2__

					   skipSpace(s);

		   			   passwordString->setPasswordString(s);

					   ret = 5;
				}
			else
				if( NULL != (s=passwordString->isStringInc("__NOMTX__" )))
				{
					   s += 9;  // len of __NOMTX__
					   skipSpace(s);

					   passwordString->setPasswordString(s);

					   ret = 6;
				}
			else
				ret = 0;


			break;
		}
	}

	pwd_file.close(); // dummy

	return( ret );
}

int Password::makeNextPassword( int level )
{
	itoa( level, ext, 10 );

	fnmerge( fname, curr_drive, curr_dir, _callsign, ext );

	digit = new int [ numOfDigit ];

	randomize();

	for ( int i = 0; i < numOfDigit; i++ )
	{
		int ch;

		Boolean done = False;

		do
		{
			ch = random( passwordString->isWildPassword() ? 255 : passwordString->lenOfPassword() );

			if( passwordOption ==  NOOPTIONS )
										done=True;

			if( passwordOption & SKIP_SPACE &&\
				( !passwordString->isWildPassword() ? *passwordString->getPos(ch) != ' ' : 1 ) )
								done=True;

			if( passwordOption & NO_DUPLICATE && i &&\
				( !passwordString->isWildPassword() ? passwordString->lenOfPassword() >= numOfDigit : 1 ) )
			{
				for( int j = 0; j < i; j++ )
					if( digit[ j ] == ( ch + 1 ) )
											done=False;
			}
		}
		while( !done );

		*nextPassword + ( ( passwordString->isWildPassword() ) ? "0" : passwordString->getPos(ch) );
		digit[ i ] = ch + 1;
	}

	if(((passwordOption & MD2_SUPPORT) && (passwordOption & MD2_CHANGE_RANDOM)) ||
		  (( passwordOption & MD2_SUPPORT ) && (!(passwordOption & MD2_CHANGE_RANDOM))  && !level ))
	{
		char temp[20];

		unsigned long num = (unsigned long) rand();

		num <<= 16;

		num |= (unsigned long) rand();

		ultoa(num,temp,10);
		int len=strlen(temp);

		MD2RandomGenerator->setString("");

		while (len++ < 10)
			*MD2RandomGenerator + "0";

		*MD2RandomGenerator + temp;
	}

	ofstream outnext (fname);

	if( ! outnext.good() )
	{
#ifdef __DEBUG__
		cout << "DEBUG: I/O Error opening outnext file" << endl;
#endif
		return(2);
	}

	outnext << nextPassword->getString() << endl
		<< lastPasswordOk << endl;

	if( passwordOption & MD2_SUPPORT )
		outnext << MD2RandomGenerator->getString() << endl;

	if( ! outnext.good() )
	{
#ifdef __DEBUG__
		cout << "DEBUG: I/O Error writing outnext file" << endl;
#endif
		return( 2 );
	}

	outnext.close(); // dummy

	return 0;
}

int Password::readPrevPassword( int level )
{

	itoa( level - 1, ext, 10);
	fnmerge( fname, curr_drive, curr_dir, _callsign, ext );

	ifstream inprev (fname);

	if( ! inprev.good() )
	{
#ifdef __DEBUG__
		cout << "DEBUG: I/O Error opening inprev file" << endl;
#endif
		return(2);
	}

	char temp[ LENLINE ];

	inprev 	>> temp
		>> lastPasswordOk;

	*prevPassword + temp;

	if( passwordOption & MD2_SUPPORT )
	{
		inprev >> temp;
		*MD2RandomGenerator + temp;
	}

	if( ! inprev.good() )
	{
#ifdef __DEBUG__
		cout << "DEBUG: I/O Error reading inprev file" << endl;
#endif
		return(2);
	}


	inprev.close();
	unlink( fname );
	return( 0 );
}

int Password::comparePassword( char *newPassword )
{
	if (( strlen(newPassword) == 32 ) && ( passwordOption & MD2_SUPPORT ))
	{
		TString temp(MD2RandomGenerator->getString());
		temp.add(passwordString->getString());

		MD2 md(temp.getString());

		if ( passwordOption & CASE_SENSITIVE )
		{
			if ( !strcmp( newPassword, md.getString() ) )
						lastPasswordOk = 'Y';

		}
		else
			if ( !stricmp( newPassword, md.getString() ) )
						lastPasswordOk = 'Y';

		return MD2_TYPE;
	}


	if ( passwordString->isWildPassword() )
				lastPasswordOk = 'Y';

	if ( lastPasswordOk == 'Y' )
				return MATRIX_TYPE;

	if ( ! stringMatch( newPassword ,prevPassword->getString() ) )
					lastPasswordOk = 'N';
	else
		lastPasswordOk = 'Y';

	return MATRIX_TYPE;
}

