//  GetPass 3.0 - C_FILTER for F6FBB BBS Software

//  Written by Marco Savegnago IW3FQG

#ifndef __GPPASS_H
#define __GPPASS_H

#include "gpmsg.h"

#include <dir.h>

#define NOOPTIONS 				0
#define CASE_SENSITIVE          1
#define SKIP_SPACE				2
#define NO_DUPLICATE			4
#define MD2_SUPPORT				8
#define MD2_CHANGE_RANDOM		16


#define LENLINE 512

enum PasswordType { MATRIX_TYPE, MD2_TYPE };

class Password
{

public:

	Password(char *call, char *fpassword, char option=NOOPTIONS, int digit=5);

	~Password();

	int 	readPassword();

	int 	makeNextPassword( int );

	int 	readPrevPassword( int );

	int 	comparePassword( char *);

	int 	isRight();
	char *  MD2init();

	int  	numOfDigit;
	int  * 	digit;

private:

	Boolean 	stringMatch( char *, char * );
	char 		*	callsign;
	char 		*  	_callsign;
	PasswordString  *  	passwordString;
	char		* 	passwordFile;
	char 			passwordOption;
	TString 	* 	prevPassword;
	TString 	* 	nextPassword;
	TString 	* 	MD2RandomGenerator;

	char 			lastPasswordOk;
	char 			curr_drive[ MAXDRIVE ];
	char 			curr_dir[ MAXDIR ];
	char 			fname[ MAXPATH ];
	char 			ext[ MAXEXT ];
};

inline int Password::isRight()
{
	return ( lastPasswordOk == 'Y' );
}

inline char *  Password::MD2init()
{
	return (MD2RandomGenerator->getString());
}

inline Boolean 	Password::stringMatch( char *st1, char *st2 )
{
	return ::stringMatch(st1, st2, Boolean(passwordOption & CASE_SENSITIVE) );
}

#endif // __GPPASS_H
