//	RESINF 1.0 - RESINF Inf.SYS Maintenance utility for F6FBB BBS Software
//  Written by Marco Savegnago IW3FQG

#include "gpmsg.h"
#include "infapps.h"
#include "infpass.h"

#include <iostream.h>
#include <iomanip.h>
#include <new.h>

#include <fstream.h>
#include <stdio.h>

ResInfApp::ResInfApp( int na, char * *a )
{
	cout << endl
			 << "RESINF 1.0 - RESINF Maintenance for F6FBB BBS Software" << endl
			 << endl
			 << "Written by Marco Savegnago IW3FQG " << __DATE__ << endl
			 << endl;


	fnsplit( a[ 0 ], curr_drive, curr_dir, curr_name, NULL );

	if(na==1)
		fnmerge ( fconfig, curr_drive, curr_dir, curr_name, ".CNF" );
	else
		*fconfig=0;


	set_new_handler( ResInfApp::new_failure );
}

ResInfApp::run()
{
	ConfigFile config ( fconfig, MAX_OPTIONS);

	// Se incontro errori leggendo il file di configurazione allora non faccio mai niente

	if(config.readFile())
	{
		cout     << "Error reading config file " << fconfig << endl;
		return 1;
	}

	PasswordList	passwords(config.getStrParam(PASSWORD_FILE));

	if(!passwords.readPasswords())
	{
		cout     << "Error reading password file " << config.getStrParam(PASSWORD_FILE) << endl;
		return 2;
	}

	if(!passwords.count)
	{
		cout     << "Error NO Password found in file file " << config.getStrParam(PASSWORD_FILE) << endl;
		return 3;
	}

	char  	inf_drive	[ MAXDRIVE ];
	char  	inf_dir  	[ MAXDIR   ];
	char  	inf_name 	[ MAXFILE  ];
	char	inf_ext  	[ MAXEXT   ];
	char	inf_bak		[ MAXPATH  ];

	//	Prendo il nome e le componenti del file INF

	fnsplit( config.getStrParam( INF_FILE ), inf_drive, inf_dir, inf_name, inf_ext);

	//	Creo il nome del file INF di backup

	fnmerge ( inf_bak, inf_drive, inf_dir, inf_name, ".BAK" );

	//	Cancella l'eventuale file di backup

	remove(inf_bak);

	//	Cambia il nome del file

	if(::rename(config.getStrParam( INF_FILE ), inf_bak)!=0)
	{
		cout    <<  "Error renaming " << config.getStrParam( INF_FILE) << endl;
		return 5;
	}

	ifstream bak(inf_bak, ios::binary );
	ofstream inf(config.getStrParam( INF_FILE ),ios::binary );

	if(!bak.good())
	{
		cout    <<  "Error opening " << inf_bak << " for reading!" << endl;
		return 6;
	}

	if(!inf.good())
	{
		cout    <<  "Error opening " << config.getStrParam( INF_FILE ) << " for writing!" << endl;
		return 7;
	}

	while(True)
	{
		info	inf_info;

		bak.read((char*)&inf_info, sizeof(info));

		if(bak.eof())
			break;

		if(passwords.Exist(inf_info.indic.callsign))
		{
			inf_info.kb	=	atoi(config.getStrParam( REGISTERED_LIMIT	));
			cout	<<	setw(6) << inf_info.indic.callsign	<< " -> " << config.getStrParam( REGISTERED_LIMIT) << endl;
		}
		else
			inf_info.kb	=	atoi(config.getStrParam( UNREGISTERED_LIMIT	));

		inf.write((char*)&inf_info, sizeof(info));
	}

	return	0;

}


void ResInfApp::new_failure()
{
#ifdef __DEBUG__
	cout << "DEBUG: Memory allocation error!" << endl;
#endif
	exit( 2 );
}

