
#include    <fstream.h>
#include    <iostream.h>
#include    <bios.h>
#include    <ctype.h>

#define NBBBS 80
#define NBMASK NBBBS/8

struct bullist
{
   char type         ;  /* 1   Type of message (A,B,P,T)       */
   char status       ;  /* 1   Status of message ($,A,F,K,N,Y) */
   long numero       ;  /* 4   Number of the message           */
   long taille       ;  /* 4   Size of message in characters   */
   long date         ;  /* 4   Date of message                 */
   char bbsf[7]      ;  /* 7   Adjacent BBS giving the message */
   char bbsv[41]     ;  /* 41  Route                           */
   char exped[7]     ;  /* 7   Destination of the message      */
   char desti[7]     ;  /* 7   To field                        */
   char bid[13]      ;  /* 13  BID or MID                      */
   char titre[61]    ;  /* 61  Title of message                */
   char free[16]     ;  /* 16  Reserved bytes                  */
   long datesd       ;  /* 4   Date of the message creation    */
   long datech       ;  /* 4   Date of last status change      */
   char fbbs[NBMASK] ;  /* 10  Mask of BBSes to forward to     */
   char forw[NBMASK] ;  /* 10  Mask of BBSes already forwarded */

};  /* 194 bytes = length of one record    */

/*
 A null type of message (00 hex) invalidates the record.

 Dates are given as the number of seconds since january 1st, 1970 00:00.

 Masks are bit fields, number of bit corresponds to the number of the BBS in
the BBS.SYS file.

In C language, all strings are ended with a NULL (00 hex) character.
*/

int isLocal(bullist&    bullettin)
{
    return (*bullettin.bbsf) ? 0 : 1;
}

void    showBullettin(long number, bullist&    bullettin)
{

    cout    <<  "Record #" << number << endl;

    cout    <<  "Type   :" << bullettin.type    << endl
            <<  "Status :" << bullettin.status  << endl
            <<  "Num    :" << bullettin.numero  << endl
            <<  "Size   :" << bullettin.taille  << endl
            <<  "bbsf   :" << bullettin.bbsf    << endl
            <<  "bbsv   :" << bullettin.bbsv    << endl
            <<  "exped  :" << bullettin.exped   << endl
            <<  "desti  :" << bullettin.desti   << endl
            <<  "bid    :" << bullettin.bid     << endl
            <<  "title  :" << bullettin.titre   << endl
            <<  endl
            ;

    if(isLocal(bullettin))
        cout << "Local\n";
    else
        cout << "Distant\n";

    cout     << endl;
}



void    usage()
{
    cout    <<  "SHDIRMES 1.0 " __DATE__ " Copyright (c) 1996 Marco Savegnago IW3FQG\n"
            <<  "Usage SHDIRMES <filename>\n"
            <<  endl;
}



int    main(int na, char *a[])
{
    if(na < 2)
    {
        usage();
        return  1;
    }

    ifstream dirmes( a[1], ios::binary );

    if(!dirmes.good())
    {
        cout    <<  "Error opening " << a[1] << " for reading!" << endl;
        return  2;
    }

    bullist    bullettin;

    long       number    =  0L;

    while(!dirmes.eof())
    {
        dirmes.read((char*)&bullettin, sizeof(bullettin));

        showBullettin(number, bullettin);

        number++;

        /* Wait until a key is pressed */
        while (_bios_keybrd(_KEYBRD_READY) == 0);


        /* Fetch the key that is waiting */
        if(toupper(_bios_keybrd(_KEYBRD_READ)) == 'Q')
                                               break;

    }

    return 0;
}

