
#include    <fstream.h>
#include    <iostream.h>
#include    <bios.h>
#include    <ctype.h>
#include    <time.h>
#include    <string.h>

#define uchar unsigned char

typedef struct {        /* Callsign structure used in info  */

  char callsign[7]   ;
  char ssid          ;

} indicat            ;

typedef struct {

  indicat  indic     ;  /* 8   Callsign                     */
  indicat  relai[8]  ;  /* 64  Digis path                   */
  long     lastmes   ;  /* 4   Last L number                */
  long     nbcon     ;  /* 4   Number of connexions         */
  long     hcon      ;  /* 4   Last connexion date          */
  long     lastyap   ;  /* 4   Last YN date                 */
  unsigned flags     ;  /* 2   Flags                        */
  unsigned on_base   ;  /* 2   ON Base number               */
  uchar    nbl       ;  /* 1   Lines paging                 */
  uchar    lang      ;  /* 1   Language                     */
  char     free[4]   ;  /* 1   Res                          */
  int      kb;
  char     free1[21]  ;  /* 27  Reserved                     */
  char     nom[18]   ;  /* 18  1st Name                     */
  char     prenom[13];  /* 13  Christian name               */
  char     adres[61] ;  /* 61  Address                      */
  char     ville[31] ;  /* 31  City                         */
  char     teld[13]  ;  /* 13  home phone                   */
  char     telp[13]  ;  /* 13  job phone                    */
  char     home[41]  ;  /* 41  home BBS                     */
  char     qra[7]    ;  /* 7   Qth Locator                  */
  char     priv[13]  ;  /* 13  PRIV directory               */
  char     filtre[7] ;  /* 7   LC choice filter             */
  char     pass[13]  ;  /* 13  Password                     */
  char     zip[9]    ;  /* 9   Zipcode                      */

} info               ;  /* 360 bytes = lenght of one record */


/*
 A null type of message (00 hex) invalidates the record.

 Dates are given as the number of seconds since january 1st, 1970 00:00.

In C language, all strings are ended with a NULL (00 hex) character.
*/


void    showInfo(long number, info&    inf)
{

    if(!strcmp(inf.indic.callsign, "I3SBB"))
                                   asm int 3;
/*
    cout    <<  "Record #" << number << endl;

    cout    <<  "Callsign :" <<  inf.indic.callsign      << endl
            <<  "LastMsg  :" <<  inf.lastmes             << endl
            <<  "NumOfC   :" <<  inf.nbcon               << endl
            <<  "LCD      :" <<  ctime(&inf.hcon)        << endl
            <<  "LY       :" <<  ctime(&inf.lastyap)     << endl
            <<  "Flags    :" <<  inf.flags               << endl
            <<  "ON base  :" <<  inf.on_base             << endl
            <<  "NBL      :" <<  inf.nbl                 << endl
            <<  "LANG     :" <<  inf.lang                << endl;
//            char     free[27]  ;

    cout
            <<  "NOME     :" <<  inf.nom                 << endl
            <<  "COGNOME  :" <<  inf.prenom              << endl
            <<  "Indirizzo:" <<  inf.adres               << endl
            <<  "Citta'   :" <<  inf.ville               << endl
            <<  "HPhone   :" <<  inf.teld                << endl
            <<  "JPhone   :" <<  inf.telp                << endl
            <<  "HBBS     :" <<  inf.home                << endl
            <<  "QRA      :" <<  inf.qra                 << endl
            <<  "PRIV     :" <<  inf.priv                << endl
            <<  "LC       :" <<  inf.filtre              << endl
            <<  "PASSWORD :" <<  inf.pass                << endl
            <<  "ZIP      :" <<  inf.zip                 << endl;


    cout     << endl;
*/
}



void    usage()
{
    cout    <<  "SHINF 1.0 " __DATE__ " Copyright (c) 1996 Marco Savegnago IW3FQG\n"
            <<  "Usage DHINF <filename>\n"
            <<  endl;
}



int    main(int na, char *a[])
{
    if(na < 2)
    {
        usage();
        return  1;
    }

    ifstream inf( a[1], ios::binary );

    if(!inf.good())
    {
        cout    <<  "Error opening " << a[1] << " for reading!" << endl;
        return  2;
    }

    info       infitem;

    long       number    =  0L;

    while(!inf.eof())
    {
        inf.read((char*)&infitem, sizeof(infitem));

        showInfo(number, infitem);

        number++;

        // Wait until a key is pressed
/*
        if(_bios_keybrd(_KEYBRD_READY) == 0)
        {
           // Fetch the key that is waiting
           if(toupper(_bios_keybrd(_KEYBRD_READ)) == 'Q')
                                                  break;
        }
*/

    }

    return 0;
}

