/*

   MD2 C++ Class type prototype

   27/10/1992 Marco Savegnago


   RSA Data Security, Inc., MD2 message-digest algorithm
   Copyright (C) 1990-2, RSA Data Security, Inc. Created 1990. All
   rights reserved.

   License to copy and use this software is granted for
   non-commercial Internet Privacy-Enhanced Mail provided that it is
   identified as the "RSA Data Security, Inc. MD2 Message Digest
   Algorithm" in all material mentioning or referencing this software
   or this function.

   RSA Data Security, Inc. makes no representations concerning either
   the merchantability of this software or the suitability of this
   software for any particular purpose. It is provided "as is"
   without express or implied warranty of any kind.

   These notices must be retained in any copies of any part of this
   documentation and/or software.
*/

#include <iostream.h>
#include <string.h>

/*
   Permutation of 0..255 constructed from the digits of pi. It gives a
   "random" nonlinear byte substitution operation.
 */

static unsigned char PI_SUBST[256] = {
  41, 46, 67, 201, 162, 216, 124, 1, 61, 54, 84, 161, 236, 240, 6,
  19, 98, 167, 5, 243, 192, 199, 115, 140, 152, 147, 43, 217, 188,
  76, 130, 202, 30, 155, 87, 60, 253, 212, 224, 22, 103, 66, 111, 24,
  138, 23, 229, 18, 190, 78, 196, 214, 218, 158, 222, 73, 160, 251,
  245, 142, 187, 47, 238, 122, 169, 104, 121, 145, 21, 178, 7, 63,
  148, 194, 16, 137, 11, 34, 95, 33, 128, 127, 93, 154, 90, 144, 50,
  39, 53, 62, 204, 231, 191, 247, 151, 3, 255, 25, 48, 179, 72, 165,
  181, 209, 215, 94, 146, 42, 172, 86, 170, 198, 79, 184, 56, 210,
  150, 164, 125, 182, 118, 252, 107, 226, 156, 116, 4, 241, 69, 157,
  112, 89, 100, 113, 135, 32, 134, 91, 207, 101, 230, 45, 168, 2, 27,
  96, 37, 173, 174, 176, 185, 246, 28, 70, 97, 105, 52, 64, 126, 15,
  85, 71, 163, 35, 221, 81, 175, 58, 195, 92, 249, 206, 186, 197,
  234, 38, 44, 83, 13, 110, 133, 40, 132, 9, 211, 223, 205, 244, 65,
  129, 77, 82, 106, 220, 55, 200, 108, 193, 171, 250, 36, 225, 123,
  8, 12, 189, 177, 74, 120, 136, 149, 139, 227, 99, 232, 109, 233,
  203, 213, 254, 59, 0, 29, 57, 242, 239, 183, 14, 102, 88, 208, 228,
  166, 119, 114, 248, 235, 117, 75, 10, 49, 68, 80, 180, 143, 237,
  31, 26, 219, 153, 141, 51, 159, 17, 131, 20
};

static unsigned char *PADDING[] = {
  (unsigned char *)"",
  (unsigned char *)"\001",
  (unsigned char *)"\002\002",
  (unsigned char *)"\003\003\003",
  (unsigned char *)"\004\004\004\004",
  (unsigned char *)"\005\005\005\005\005",
  (unsigned char *)"\006\006\006\006\006\006",
  (unsigned char *)"\007\007\007\007\007\007\007",
  (unsigned char *)"\010\010\010\010\010\010\010\010",
  (unsigned char *)"\011\011\011\011\011\011\011\011\011",
  (unsigned char *)"\012\012\012\012\012\012\012\012\012\012",
  (unsigned char *)"\013\013\013\013\013\013\013\013\013\013\013",
  (unsigned char *)"\014\014\014\014\014\014\014\014\014\014\014\014",
  (unsigned char *)
    "\015\015\015\015\015\015\015\015\015\015\015\015\015",
  (unsigned char *)
    "\016\016\016\016\016\016\016\016\016\016\016\016\016\016",
  (unsigned char *)
    "\017\017\017\017\017\017\017\017\017\017\017\017\017\017\017",
  (unsigned char *)
    "\020\020\020\020\020\020\020\020\020\020\020\020\020\020\020\020"
};

class MD2
{
	unsigned int count;                 /* number of bytes, modulo 16 */
	unsigned char state[16];                                 /* state */
	unsigned char checksum[16];                           /* checksum */
	unsigned char buffer[16];                         /* input buffer */
	unsigned char digest[16];                         /* output buffer */
	unsigned char digestString[33];

	void transform(char *block);


public:

	MD2();
	MD2(char *string);
	void init();
	void update(unsigned char *input, unsigned int inputLen );
	void final();
	inline char *getDigest();
	char *getString();
        void setString(char *str);
};


void MD2::init()
{
	count = 0;
	memset(state,'\0', sizeof state );
	memset(checksum,'\0', sizeof checksum );
	memset(buffer,'\0', sizeof buffer );
	memset(digest,'\0', sizeof digest );
	memset(digestString,'\0', sizeof digestString );

}

MD2::MD2()
{
	init();
}


MD2::MD2(char *string)
{
	init();
	update(string, strlen (string));
        final();
}

void MD2::update(unsigned char *input, unsigned int inputLen )
{
	/* Update number of bytes mod 16 */
	unsigned int index = count;

	count = (index + inputLen) & 0xf;

        unsigned int partLen = 16 - index;

        /* Transform as many times as possible.
	*/

        int i;

	if (inputLen >= partLen)
        {
                memcpy(&buffer[index], input, partLen);

		transform (buffer);

		for (i = partLen; i + 15 < inputLen; i += 16)
                                                        transform (&input[i]);

                index = 0;
        }
        else
                i = 0;

        /* Buffer remaining input */

	memcpy(&buffer[index], &input[i], inputLen - i);
}

void MD2::transform(char *block)
{
	unsigned char x[48];

	/* Form encryption block from state, block, state ^ block.
	*/

	memcpy(x, state, 16);
	memcpy(x + 16, block, 16);

	for (int i = 0; i < 16; i++)
		x[i+32] = state[i] ^ block[i];

	/* Encrypt block (18 rounds).
	*/

	int t = 0;

	for (i = 0; i < 18; i++)
	{
		for (int j = 0; j < 48; j++)
			t = x[j] ^= PI_SUBST[t];

		t = (t + i) & 0xff;
	}

	/* Save new state */
	memcpy(state, x, 16);

	t = checksum[15];

	for (i = 0; i < 16; i++)
		t = checksum[i] ^= PI_SUBST[block[i] ^ t];

}

void MD2::final()
{
	/* Pad out to multiple of 16.
	*/
	unsigned int index = count;
	unsigned padLen = 16 - index;
	update(PADDING[padLen], padLen);

	update (checksum, 16);

	/* Store state in digest */

	memcpy(digest, state, 16);

}

char *MD2::getDigest()
{
	return digest;
}

char *MD2::getString()
{
	char *d=digestString;

	for (int i = 0 ; i < 16; i++)
	{
		unsigned char  s=digest[i];
		unsigned char  h=s/16;
		unsigned char  l=s-(h*16);

		*d++ = (h <= 9) ? h + '0' : (h - 10) + 'a';
		*d++ = (l <= 9) ? l + '0' : (l - 10) + 'a';
	}
	*d=NULL;
	return digestString;
}


void MD2::setString(char *str)
{
	init();
	update(str, strlen(str));
	final();
}

ostream& operator << (ostream& os, MD2& md)
{
	os << md.getString();
	return os;
}

// The program begin here ...

main()
{
	MD2 md;

        cout << "Enter string : " ;

	char temp[256];

	cin >> temp;

	md.setString(temp);

        cout << endl << "Result : " << md << endl;

	return 0;
}


